/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRI
extends AbstractSegment {
    public QRI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Candidate Confidence");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(392)}, "Match Reason Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Algorithm Descriptor");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QRI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getCandidateConfidence() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getQri1_CandidateConfidence() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public IS[] getMatchReasonCode() {
        IS[] retVal = (IS[])this.getTypedField(2, new IS[0]);
        return retVal;
    }

    public IS[] getQri2_MatchReasonCode() {
        IS[] retVal = (IS[])this.getTypedField(2, new IS[0]);
        return retVal;
    }

    public int getMatchReasonCodeReps() {
        return this.getReps(2);
    }

    public IS getMatchReasonCode(int rep) {
        IS retVal = (IS)this.getTypedField(2, rep);
        return retVal;
    }

    public IS getQri2_MatchReasonCode(int rep) {
        IS retVal = (IS)this.getTypedField(2, rep);
        return retVal;
    }

    public int getQri2_MatchReasonCodeReps() {
        return this.getReps(2);
    }

    public IS insertMatchReasonCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(2, rep);
    }

    public IS insertQri2_MatchReasonCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(2, rep);
    }

    public IS removeMatchReasonCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(2, rep);
    }

    public IS removeQri2_MatchReasonCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(2, rep);
    }

    public CWE getAlgorithmDescriptor() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getQri3_AlgorithmDescriptor() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(392));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

