/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.PLN;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRD
extends AbstractSegment {
    public PRD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 0, 705, new Object[]{this.getMessage()}, "Provider Role");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Address");
            this.add(PL.class, false, 1, 60, new Object[]{this.getMessage()}, "Provider Location");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Communication Information");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Preferred Method of Contact");
            this.add(PLN.class, false, 0, 100, new Object[]{this.getMessage()}, "Provider Identifiers");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Effective Start Date of Provider Role");
            this.add(DTM.class, false, 0, 24, new Object[]{this.getMessage()}, "Effective End Date of Provider Role");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "Provider Organization Name and Identifier");
            this.add(XAD.class, false, 0, 60, new Object[]{this.getMessage()}, "Provider Organization Address");
            this.add(PL.class, false, 0, 60, new Object[]{this.getMessage()}, "Provider Organization Location Information");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Organization Communication Information");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Provider Organization Method of Contact");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE[] getProviderRole() {
        CWE[] retVal = (CWE[])this.getTypedField(1, new CWE[0]);
        return retVal;
    }

    public CWE[] getPrd1_ProviderRole() {
        CWE[] retVal = (CWE[])this.getTypedField(1, new CWE[0]);
        return retVal;
    }

    public int getProviderRoleReps() {
        return this.getReps(1);
    }

    public CWE getProviderRole(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public CWE getPrd1_ProviderRole(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPrd1_ProviderRoleReps() {
        return this.getReps(1);
    }

    public CWE insertProviderRole(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE insertPrd1_ProviderRole(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE removeProviderRole(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public CWE removePrd1_ProviderRole(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public XPN[] getProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public XPN[] getPrd2_ProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public int getProviderNameReps() {
        return this.getReps(2);
    }

    public XPN getProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public XPN getPrd2_ProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPrd2_ProviderNameReps() {
        return this.getReps(2);
    }

    public XPN insertProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertPrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removePrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XAD[] getProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public XAD[] getPrd3_ProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public int getProviderAddressReps() {
        return this.getReps(3);
    }

    public XAD getProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public XAD getPrd3_ProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPrd3_ProviderAddressReps() {
        return this.getReps(3);
    }

    public XAD insertProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD insertPrd3_ProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD removeProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XAD removePrd3_ProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public PL getProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public PL getPrd4_ProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN[] getProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public XTN[] getPrd5_ProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public int getProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN getProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public XTN getPrd5_ProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrd5_ProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN insertProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertPrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removeProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removePrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public CWE getPreferredMethodOfContact() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getPrd6_PreferredMethodOfContact() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public PLN[] getProviderIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, new PLN[0]);
        return retVal;
    }

    public PLN[] getPrd7_ProviderIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, new PLN[0]);
        return retVal;
    }

    public int getProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN getProviderIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public PLN getPrd7_ProviderIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPrd7_ProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN insertProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN insertPrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN removeProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    public PLN removePrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    public DTM getEffectiveStartDateOfProviderRole() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getPrd8_EffectiveStartDateOfProviderRole() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM[] getEffectiveEndDateOfProviderRole() {
        DTM[] retVal = (DTM[])this.getTypedField(9, new DTM[0]);
        return retVal;
    }

    public DTM[] getPrd9_EffectiveEndDateOfProviderRole() {
        DTM[] retVal = (DTM[])this.getTypedField(9, new DTM[0]);
        return retVal;
    }

    public int getEffectiveEndDateOfProviderRoleReps() {
        return this.getReps(9);
    }

    public DTM getEffectiveEndDateOfProviderRole(int rep) {
        DTM retVal = (DTM)this.getTypedField(9, rep);
        return retVal;
    }

    public DTM getPrd9_EffectiveEndDateOfProviderRole(int rep) {
        DTM retVal = (DTM)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPrd9_EffectiveEndDateOfProviderRoleReps() {
        return this.getReps(9);
    }

    public DTM insertEffectiveEndDateOfProviderRole(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(9, rep);
    }

    public DTM insertPrd9_EffectiveEndDateOfProviderRole(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(9, rep);
    }

    public DTM removeEffectiveEndDateOfProviderRole(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(9, rep);
    }

    public DTM removePrd9_EffectiveEndDateOfProviderRole(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(9, rep);
    }

    public XON getProviderOrganizationNameAndIdentifier() {
        XON retVal = (XON)this.getTypedField(10, 0);
        return retVal;
    }

    public XON getPrd10_ProviderOrganizationNameAndIdentifier() {
        XON retVal = (XON)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getProviderOrganizationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public XAD[] getPrd11_ProviderOrganizationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public int getProviderOrganizationAddressReps() {
        return this.getReps(11);
    }

    public XAD getProviderOrganizationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getPrd11_ProviderOrganizationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPrd11_ProviderOrganizationAddressReps() {
        return this.getReps(11);
    }

    public XAD insertProviderOrganizationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertPrd11_ProviderOrganizationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeProviderOrganizationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removePrd11_ProviderOrganizationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public PL[] getProviderOrganizationLocationInformation() {
        PL[] retVal = (PL[])this.getTypedField(12, new PL[0]);
        return retVal;
    }

    public PL[] getPrd12_ProviderOrganizationLocationInformation() {
        PL[] retVal = (PL[])this.getTypedField(12, new PL[0]);
        return retVal;
    }

    public int getProviderOrganizationLocationInformationReps() {
        return this.getReps(12);
    }

    public PL getProviderOrganizationLocationInformation(int rep) {
        PL retVal = (PL)this.getTypedField(12, rep);
        return retVal;
    }

    public PL getPrd12_ProviderOrganizationLocationInformation(int rep) {
        PL retVal = (PL)this.getTypedField(12, rep);
        return retVal;
    }

    public int getPrd12_ProviderOrganizationLocationInformationReps() {
        return this.getReps(12);
    }

    public PL insertProviderOrganizationLocationInformation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(12, rep);
    }

    public PL insertPrd12_ProviderOrganizationLocationInformation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(12, rep);
    }

    public PL removeProviderOrganizationLocationInformation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(12, rep);
    }

    public PL removePrd12_ProviderOrganizationLocationInformation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(12, rep);
    }

    public XTN[] getProviderOrganizationCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(13, new XTN[0]);
        return retVal;
    }

    public XTN[] getPrd13_ProviderOrganizationCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(13, new XTN[0]);
        return retVal;
    }

    public int getProviderOrganizationCommunicationInformationReps() {
        return this.getReps(13);
    }

    public XTN getProviderOrganizationCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public XTN getPrd13_ProviderOrganizationCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPrd13_ProviderOrganizationCommunicationInformationReps() {
        return this.getReps(13);
    }

    public XTN insertProviderOrganizationCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN insertPrd13_ProviderOrganizationCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN removeProviderOrganizationCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN removePrd13_ProviderOrganizationCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public CWE getProviderOrganizationMethodOfContact() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getPrd14_ProviderOrganizationMethodOfContact() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new PL(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new PLN(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new XON(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new PL(this.getMessage());
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

