/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RMI
extends AbstractSegment {
    public RMI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Risk Management Incident Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time Incident");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Incident Type Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RMI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getRiskManagementIncidentCode() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getRmi1_RiskManagementIncidentCode() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDateTimeIncident() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getRmi2_DateTimeIncident() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getIncidentTypeCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRmi3_IncidentTypeCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

