/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.PPR_PC1_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.group.PPR_PC1_PROBLEM;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPR_PC1
extends AbstractMessage {
    public PPR_PC1() {
        this(new DefaultModelClassFactory());
    }

    public PPR_PC1(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(PID.class, true, false);
            this.add(PPR_PC1_PATIENT_VISIT.class, false, false);
            this.add(PPR_PC1_PROBLEM.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPR_PC1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PPR_PC1_PATIENT_VISIT getPATIENT_VISIT() {
        return this.getTyped("PATIENT_VISIT", PPR_PC1_PATIENT_VISIT.class);
    }

    public PPR_PC1_PROBLEM getPROBLEM() {
        return this.getTyped("PROBLEM", PPR_PC1_PROBLEM.class);
    }

    public PPR_PC1_PROBLEM getPROBLEM(int rep) {
        return this.getTyped("PROBLEM", rep, PPR_PC1_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PPR_PC1_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PPR_PC1_PROBLEM.class);
    }

    public void insertPROBLEM(PPR_PC1_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public PPR_PC1_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPR_PC1_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPR_PC1_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPR_PC1_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }
}

