/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v23.datatype.CN;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXO
extends AbstractSegment {
    public RXO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Requested Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Requested Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Amount - Maximum");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Requested Give Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Requested Dosage Form");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Provider's Pharmacy Instructions");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Provider's Administration Instructions");
            this.add(CM_LA1.class, false, 1, 200, new Object[]{this.getMessage()}, "Deliver To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(161)}, "Allow Substitutions");
            this.add(CE.class, false, 1, 100, new Object[]{this.getMessage()}, "Requested Dispense Code");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Dispense Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Requested Dispense Units");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Number of Refills");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Ordering Provider's DEA Number");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Pharmacist/Treatment Supplier's Verifier ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Per (Time Unit)");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Strength");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Requested Give Strength Units");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Indication");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Requested Give Rate Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Requested Give Rate Units");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getRequestedGiveCode() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getRxo1_RequestedGiveCode() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRequestedGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxo2_RequestedGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRequestedGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxo3_RequestedGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRequestedGiveUnits() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRxo4_RequestedGiveUnits() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRequestedDosageForm() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxo5_RequestedDosageForm() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE[] getProviderSPharmacyInstructions() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public CE[] getRxo6_ProviderSPharmacyInstructions() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public int getProviderSPharmacyInstructionsReps() {
        return this.getReps(6);
    }

    public CE getProviderSPharmacyInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public CE getRxo6_ProviderSPharmacyInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getRxo6_ProviderSPharmacyInstructionsReps() {
        return this.getReps(6);
    }

    public CE insertProviderSPharmacyInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE insertRxo6_ProviderSPharmacyInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE removeProviderSPharmacyInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE removeRxo6_ProviderSPharmacyInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE[] getProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public CE[] getRxo7_ProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public int getProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE getProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public CE getRxo7_ProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxo7_ProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertRxo7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeRxo7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CM_LA1 getDeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_LA1 getRxo8_DeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getAllowSubstitutions() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getRxo9_AllowSubstitutions() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getRequestedDispenseCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getRxo10_RequestedDispenseCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRequestedDispenseAmount() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getRxo11_RequestedDispenseAmount() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getRequestedDispenseUnits() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getRxo12_RequestedDispenseUnits() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getNumberOfRefills() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getRxo13_NumberOfRefills() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public CN getOrderingProviderSDEANumber() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public CN getRxo14_OrderingProviderSDEANumber() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public CN getPharmacistTreatmentSupplierSVerifierID() {
        CN retVal = (CN)this.getTypedField(15, 0);
        return retVal;
    }

    public CN getRxo15_PharmacistTreatmentSupplierSVerifierID() {
        CN retVal = (CN)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getRxo16_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getRequestedGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getRxo17_RequestedGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRequestedGiveStrength() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getRxo18_RequestedGiveStrength() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getRequestedGiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getRxo19_RequestedGiveStrengthUnits() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getIndication() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getRxo20_Indication() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getRequestedGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getRxo21_RequestedGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getRequestedGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getRxo22_RequestedGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CM_LA1(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(161));
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new CN(this.getMessage());
            }
            case 14: {
                return new CN(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new NM(this.getMessage());
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

