/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v21.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v21.segment.NTE;
import ca.uhn.hl7v2.model.v21.segment.OBR;
import ca.uhn.hl7v2.model.v21.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORU_R01_ORDER_OBSERVATION
extends AbstractGroup {
    public ORU_R01_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ORU_R01_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORU_R01_ORDER_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.1";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORU_R01_OBSERVATION getOBSERVATION() {
        ORU_R01_OBSERVATION retVal = this.getTyped("OBSERVATION", ORU_R01_OBSERVATION.class);
        return retVal;
    }

    public ORU_R01_OBSERVATION getOBSERVATION(int rep) {
        ORU_R01_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, ORU_R01_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORU_R01_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R01_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public ORU_R01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

