/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class LoincCode
extends PersistentObject
implements ICodeElement,
ICoding {
    public static final String TABLENAME = "at_medevit_elexis_loinc";
    public static final String VERSION = "1.0.0";
    public static final String VERSIONTOPID = "TOP2000VERSION";
    public static final String VERSIONCLINICALID = "CLINICALVERSION";
    public static final String VERSIONID = "VERSION";
    public static final String FLD_CODE = "code";
    public static final String FLD_LONGNAME = "longname";
    public static final String FLD_SHORTNAME = "shortname";
    public static final String FLD_CLASS = "class";
    public static final String FLD_UNIT = "unit";
    static final String create = "CREATE TABLE at_medevit_elexis_loinc (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',code VARCHAR(128),longname TEXT,shortname VARCHAR(255),class VARCHAR(128),unit VARCHAR(128));CREATE INDEX loinc1 ON at_medevit_elexis_loinc (code);INSERT INTO at_medevit_elexis_loinc (ID,code) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");" + "INSERT INTO " + "at_medevit_elexis_loinc" + " (ID," + "code" + ") VALUES (" + JdbcLink.wrap((String)"TOP2000VERSION") + "," + JdbcLink.wrap((String)"0.0.0") + ");" + "INSERT INTO " + "at_medevit_elexis_loinc" + " (ID," + "code" + ") VALUES (" + JdbcLink.wrap((String)"CLINICALVERSION") + "," + JdbcLink.wrap((String)"0.0.0") + ");";

    static {
        LoincCode.addMapping((String)TABLENAME, (String[])new String[]{FLD_CODE, FLD_LONGNAME, FLD_SHORTNAME, FLD_CLASS, FLD_UNIT});
        if (!LoincCode.tableExists((String)TABLENAME)) {
            LoincCode.createOrModifyTable((String)create);
        } else {
            LoincCode version = LoincCode.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get(FLD_CODE));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_CODE, VERSION);
            }
        }
    }

    public LoincCode(String id) {
        super(id);
    }

    public LoincCode(String code, String longname, String shortname, String clazz, String unit) {
        this.create(null);
        this.set(FLD_CODE, code);
        this.set(FLD_LONGNAME, longname);
        this.set(FLD_SHORTNAME, shortname);
        this.set(FLD_CLASS, clazz);
        this.set(FLD_UNIT, unit);
    }

    public LoincCode() {
    }

    public static LoincCode load(String id) {
        return new LoincCode(id);
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_CODE, FLD_LONGNAME});
        if (vals[1].trim().length() > 0) {
            return String.valueOf(vals[0]) + " - " + vals[1].trim();
        }
        return vals[0];
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCodeSystemName() {
        return "LOINC";
    }

    public String getCodeSystemCode() {
        return "999";
    }

    public String getCode() {
        return this.get(FLD_CODE);
    }

    public String getText() {
        return this.get(FLD_LONGNAME);
    }

    public static VersionInfo getDataVersion(String versionId) {
        LoincCode dataVersion = LoincCode.load(versionId);
        return new VersionInfo(dataVersion.get(FLD_CODE));
    }

    public static void setDataVersion(String versionId, String version) {
        LoincCode dataVersion = LoincCode.load(versionId);
        if (!dataVersion.exists()) {
            dataVersion.create(versionId);
        }
        dataVersion.set(FLD_CODE, version);
    }

    public List<Object> getActions(Object context) {
        return null;
    }

    public String getSystem() {
        return CodingSystem.LOINC_CODESYSTEM.getSystem();
    }

    public String getDisplay() {
        return this.getText();
    }
}

