/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.model.impl;

import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.IInboxUpdateListener;
import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.model.InboxElementType;
import at.medevit.elexis.inbox.model.impl.ElementsProviderExtension;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class InboxElementService
implements IInboxElementService {
    HashSet<IInboxUpdateListener> listeners = new HashSet();

    @Override
    public void createInboxElement(Patient patient, Kontakt mandant, PersistentObject object) {
        InboxElement element = new InboxElement(patient, mandant, object);
        this.fireUpdate(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdateListener(IInboxUpdateListener listener) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUpdateListener(IInboxUpdateListener listener) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<InboxElement> getInboxElements(Mandant mandant, Patient patient, IInboxElementService.State state) {
        Query qie = new Query(InboxElement.class);
        if (mandant != null) {
            qie.add("mandant", "=", mandant.getId());
        }
        if (patient != null) {
            qie.add("patient", "=", patient.getId());
        }
        if (state != null) {
            qie.add("state", "=", Integer.toString(state.ordinal()));
        }
        return qie.execute();
    }

    @Override
    public void changeInboxElementState(InboxElement element, IInboxElementService.State state) {
        element.set("state", Integer.toString(state.ordinal()));
        this.fireUpdate(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate(InboxElement element) {
        HashSet<IInboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            for (IInboxUpdateListener listener : this.listeners) {
                listener.update(element);
            }
        }
    }

    @Activate
    public void activate() {
        this.activateProviders();
    }

    @Deactivate
    public void deactivate() {
        this.deactivateProviders();
    }

    @Override
    public void createInboxElement(Patient patient, Kontakt mandant, String file, boolean copyFile) {
        File src;
        String path = file;
        if (path != null && (src = new File(path)).exists()) {
            if (copyFile) {
                try {
                    StringBuilder pathBuilder = new StringBuilder();
                    pathBuilder.append("inbox");
                    pathBuilder.append(File.separator);
                    pathBuilder.append(patient.getPatCode());
                    pathBuilder.append("_");
                    pathBuilder.append(System.currentTimeMillis());
                    pathBuilder.append("_");
                    pathBuilder.append(src.getName());
                    File dest = new File(CoreHub.getWritableUserDir(), pathBuilder.toString());
                    FileUtils.copyFile((File)src, (File)dest);
                    path = dest.getAbsolutePath();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(InboxElementService.class).error("file copy error", (Throwable)e);
                    return;
                }
            }
            InboxElement element = new InboxElement(patient, mandant, String.valueOf(InboxElementType.FILE.getPrefix()) + path);
            this.fireUpdate(element);
        }
    }

    @Override
    public void deactivateProviders() {
        LoggerFactory.getLogger(this.getClass()).info("Deactivating all ElementProviders");
        ElementsProviderExtension.deactivateAll();
    }

    @Override
    public void activateProviders() {
        LoggerFactory.getLogger(this.getClass()).info("Activating all ElementProviders");
        ElementsProviderExtension.activateAll();
    }
}

