/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.model;

import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.InboxElementType;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.nio.file.Path;
import java.nio.file.Paths;

public class InboxElement
extends PersistentObject {
    public static final String TABLENAME = "at_medevit_elexis_inbox";
    public static final String VERSION = "1.0.0";
    public static final String VERSIONID = "VERSION";
    public static final String FLD_PATIENT = "patient";
    public static final String FLD_MANDANT = "mandant";
    public static final String FLD_STATE = "state";
    public static final String FLD_OBJECT = "object";
    static final String create = "CREATE TABLE at_medevit_elexis_inbox (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',patient VARCHAR(128),mandant VARCHAR(128),state VARCHAR(1),object VARCHAR(128));CREATE INDEX inbox1 ON at_medevit_elexis_inbox (patient);CREATE INDEX inbox2 ON at_medevit_elexis_inbox (mandant);INSERT INTO at_medevit_elexis_inbox (ID,patient) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        InboxElement.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENT, FLD_MANDANT, FLD_STATE, FLD_OBJECT});
        if (!InboxElement.tableExists((String)TABLENAME)) {
            InboxElement.createOrModifyTable((String)create);
        } else {
            InboxElement version = InboxElement.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENT));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_PATIENT, VERSION);
            }
        }
    }

    public static String getStateLabel(IInboxElementService.State state) {
        switch (state) {
            case NEW: {
                return "Neu";
            }
            case SEEN: {
                return "Gesehen";
            }
        }
        return "???";
    }

    public InboxElement(String id) {
        super(id);
    }

    public InboxElement(Patient patient, Kontakt mandant, PersistentObject object) {
        this(patient, mandant, object.storeToString());
    }

    public InboxElement(Patient patient, Kontakt mandant, String element) {
        this.create(null);
        this.set(FLD_PATIENT, patient != null ? patient.getId() : "");
        this.set(FLD_MANDANT, mandant.getId());
        this.set(FLD_OBJECT, element);
        this.set(FLD_STATE, Integer.toString(IInboxElementService.State.NEW.ordinal()));
    }

    public InboxElement() {
    }

    public static InboxElement load(String id) {
        return new InboxElement(id);
    }

    public String getLabel() {
        Object element = this.getObject();
        if (element instanceof PersistentObject) {
            return ((PersistentObject)element).getLabel();
        }
        if (element instanceof Path) {
            return ((Path)element).getFileName().toString();
        }
        return "InboxElement " + this.getId() + " with no object.";
    }

    public Object getObject() {
        String uri = this.get(FLD_OBJECT);
        InboxElementType inboxElementType = InboxElementType.parseType(uri);
        if (inboxElementType != null) {
            switch (inboxElementType) {
                case DB: {
                    PersistentObject object = CoreHub.poFactory.createFromString(uri);
                    if (object == null || !object.exists()) break;
                    return object;
                }
                case FILE: {
                    String refFile = uri.substring(InboxElementType.FILE.getPrefix().length());
                    Path p = Paths.get(refFile, new String[0]);
                    return p;
                }
            }
        }
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public IInboxElementService.State getState() {
        String stateStr = InboxElement.checkNull((Object)this.get(FLD_STATE));
        if (stateStr.isEmpty()) {
            return IInboxElementService.State.NEW;
        }
        return IInboxElementService.State.values()[Integer.parseInt(stateStr.trim())];
    }

    public void setState(IInboxElementService.State state) {
        this.set(FLD_STATE, Integer.toString(state.ordinal()));
    }

    public Patient getPatient() {
        Patient ret = Patient.load((String)InboxElement.checkNull((Object)this.get(FLD_PATIENT)));
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    public Mandant getMandant() {
        Mandant ret = Mandant.load((String)InboxElement.checkNull((Object)this.get(FLD_MANDANT)));
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    public void setMandant(Mandant mandant) {
        this.set(FLD_MANDANT, mandant.getId());
    }
}

