/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part.provider;

import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxElementUiExtension {
    private static Logger logger = LoggerFactory.getLogger(InboxElementUiExtension.class);
    private List<IInboxElementUiProvider> providers = this.getExtensions();

    public List<IInboxElementUiProvider> getProviders() {
        return this.providers;
    }

    private IInboxElementUiProvider getProvider(InboxElement element) {
        for (IInboxElementUiProvider iInboxElementUiProvider : this.providers) {
            if (!iInboxElementUiProvider.isProviderFor(element)) continue;
            return iInboxElementUiProvider;
        }
        return null;
    }

    private List<IInboxElementUiProvider> getExtensions() {
        ArrayList<IInboxElementUiProvider> ret = new ArrayList<IInboxElementUiProvider>();
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint("at.medevit.elexis.inbox.ui.elementsui");
        if (exp != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = exp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("uiprovider")) {
                        try {
                            ret.add((IInboxElementUiProvider)el.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            logger.error("Error creating IInboxElementsProvider " + (Object)((Object)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ret;
    }

    public String getText(InboxElement element) {
        IInboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getLabelProvider() != null) {
            return provider.getLabelProvider().getText((Object)element);
        }
        return null;
    }

    public Image getImage(InboxElement element) {
        IInboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getLabelProvider() != null) {
            return provider.getLabelProvider().getImage((Object)element);
        }
        return null;
    }

    public Color getForeground(InboxElement element) {
        IInboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getColorProvider() != null) {
            return provider.getColorProvider().getForeground((Object)element);
        }
        return null;
    }

    public Color getBackground(InboxElement element) {
        IInboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getColorProvider() != null) {
            return provider.getColorProvider().getBackground((Object)element);
        }
        return null;
    }

    public void fireDoubleClicked(InboxElement element) {
        IInboxElementUiProvider provider = this.getProvider(element);
        if (provider != null) {
            provider.doubleClicked(element);
        }
    }
}

