/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part.provider;

import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementUiExtension;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Patient;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InboxElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private InboxElementUiExtension extension = new InboxElementUiExtension();

    public String getText(Object element) {
        if (element instanceof PatientInboxElements) {
            return ((PatientInboxElements)element).toString();
        }
        if (element instanceof InboxElement) {
            String text = this.extension.getText((InboxElement)element);
            if (text != null) {
                return text;
            }
            return "unbekannt";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof PatientInboxElements) {
            Patient pat = ((PatientInboxElements)element).getPatient();
            if (pat != null) {
                if (pat.getGeschlecht().equals("m")) {
                    return Images.IMG_MANN.getImage();
                }
                return Images.IMG_FRAU.getImage();
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        if (element instanceof InboxElement) {
            Image image = this.extension.getImage((InboxElement)element);
            if (image != null) {
                return image;
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        return null;
    }

    public Color getForeground(Object element) {
        Color color;
        if (element instanceof InboxElement && (color = this.extension.getForeground((InboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        Color color;
        if (element instanceof InboxElement && (color = this.extension.getBackground((InboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(1);
    }
}

