/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part.provider;

import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class InboxElementContentProvider
implements ITreeContentProvider {
    HashMap<Patient, PatientInboxElements> map = new HashMap();
    private ArrayList<PatientInboxElements> items;

    public Object[] getElements(Object inputElement) {
        if (this.items != null) {
            return this.items.toArray();
        }
        return Collections.emptyList().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PatientInboxElements) {
            return ((PatientInboxElements)parentElement).getElements().toArray();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof PatientInboxElements;
    }

    public Object[] getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof List) {
            List input = (List)newInput;
            this.map.clear();
            for (InboxElement inboxElement : input) {
                Patient patient = inboxElement.getPatient();
                PatientInboxElements patientInbox = this.map.get(patient);
                if (patientInbox == null) {
                    patientInbox = new PatientInboxElements(patient);
                    this.map.put(patient, patientInbox);
                }
                patientInbox.addElement(inboxElement);
            }
            this.items = new ArrayList<PatientInboxElements>(this.map.values());
        }
    }

    public void refreshElement(InboxElement inboxElement) {
        Patient patient = inboxElement.getPatient();
        PatientInboxElements patientInboxElement = this.map.get(patient);
        if (patientInboxElement != null) {
            if (inboxElement.getState() == IInboxElementService.State.SEEN) {
                patientInboxElement.removeElement(inboxElement);
            } else {
                Mandant activeMandant = ElexisEventDispatcher.getSelectedMandator();
                if (inboxElement.getMandant().equals((Object)activeMandant)) {
                    patientInboxElement.addElement(inboxElement);
                } else {
                    patientInboxElement.removeElement(inboxElement);
                }
            }
        } else if (inboxElement.getState() == IInboxElementService.State.NEW) {
            patientInboxElement = new PatientInboxElements(patient);
            patientInboxElement.addElement(inboxElement);
        }
    }

    public void refreshElement(PatientInboxElements patientInbox) {
        if (patientInbox.getElements().isEmpty()) {
            this.items.remove(patientInbox);
        } else {
            Mandant activeMandant = ElexisEventDispatcher.getSelectedMandator();
            Mandant inboxMandant = patientInbox.getElements().get(0).getMandant();
            if (!inboxMandant.equals((Object)activeMandant)) {
                this.items.remove(patientInbox);
            }
        }
    }
}

