/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part;

import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.model.IInboxUpdateListener;
import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.ui.InboxServiceComponent;
import at.medevit.elexis.inbox.ui.part.action.InboxFilterAction;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementContentProvider;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementLabelProvider;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementUiExtension;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class InboxView
extends ViewPart {
    private Text filterText;
    private CheckboxTreeViewer viewer;
    private boolean reloadPending;
    private InboxElementViewerFilter filter = new InboxElementViewerFilter();
    private ElexisUiEventListenerImpl mandantChanged = new ElexisUiEventListenerImpl(Mandant.class, 128){

        public void runInUi(ElexisEvent ev) {
            InboxView.this.reload();
        }
    };
    private InboxElementContentProvider contentProvider;
    private boolean setAutoSelectPatient;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite filterComposite = new Composite(composite, 0);
        GridData data = new GridData(768);
        filterComposite.setLayoutData((Object)data);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(filterComposite, 128);
        this.filterText.setMessage("Filter");
        data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InboxView.this.filterText.getText().length() > 1) {
                    InboxView.this.filter.setSearchText(InboxView.this.filterText.getText());
                    InboxView.this.viewer.refresh();
                } else {
                    InboxView.this.filter.setSearchText("");
                    InboxView.this.viewer.refresh();
                }
            }
        });
        ToolBarManager menuManager = new ToolBarManager(8388928);
        menuManager.createControl(filterComposite);
        this.viewer = new CheckboxTreeViewer(composite, 2818);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)gd);
        ViewerFilter[] filters = new ViewerFilter[]{this.filter};
        this.viewer.setFilters(filters);
        this.contentProvider = new InboxElementContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new InboxElementLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof PatientInboxElements) {
                    PatientInboxElements patientInbox = (PatientInboxElements)event.getElement();
                    for (InboxElement inboxElement : patientInbox.getElements()) {
                        if (InboxView.this.filter.isActive() && !InboxView.this.filter.isSelect(inboxElement)) continue;
                        IInboxElementService.State newState = InboxView.this.toggleInboxElementState(inboxElement);
                        if (newState == IInboxElementService.State.NEW) {
                            InboxView.this.viewer.setChecked((Object)inboxElement, false);
                        } else {
                            InboxView.this.viewer.setChecked((Object)inboxElement, true);
                        }
                        InboxView.this.contentProvider.refreshElement(inboxElement);
                    }
                    InboxView.this.contentProvider.refreshElement(patientInbox);
                } else if (event.getElement() instanceof InboxElement) {
                    InboxElement inboxElement = (InboxElement)event.getElement();
                    if (!InboxView.this.filter.isActive() || InboxView.this.filter.isSelect(inboxElement)) {
                        InboxView.this.toggleInboxElementState(inboxElement);
                        InboxView.this.contentProvider.refreshElement(inboxElement);
                    }
                }
                InboxView.this.viewer.refresh(false);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObj;
                StructuredSelection selection = (StructuredSelection)InboxView.this.viewer.getSelection();
                if (!selection.isEmpty() && (selectedObj = selection.getFirstElement()) instanceof InboxElement) {
                    InboxElementUiExtension extension = new InboxElementUiExtension();
                    extension.fireDoubleClicked((InboxElement)selectedObj);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty() && InboxView.this.setAutoSelectPatient) {
                    Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                    if (selectedElement instanceof InboxElement) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((InboxElement)selectedElement).getPatient());
                    } else if (selectedElement instanceof PatientInboxElements) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PatientInboxElements)selectedElement).getPatient());
                    }
                }
            }
        });
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    Patient patient = null;
                    if (event.item != null) {
                        Object data = event.item.getData();
                        if (data instanceof InboxElement) {
                            patient = ((InboxElement)data).getPatient();
                        } else if (data instanceof PatientInboxElements) {
                            patient = ((PatientInboxElements)data).getPatient();
                        }
                    }
                    if (patient == null) {
                        patient = ElexisEventDispatcher.getSelectedPatient();
                    }
                    if (patient != null) {
                        if (files != null) {
                            String[] stringArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String file = stringArray[n2];
                                try {
                                    InboxServiceComponent.getService().createInboxElement(patient, (Kontakt)ElexisEventDispatcher.getSelectedMandator(), file, true);
                                }
                                catch (Exception e) {
                                    LoggerFactory.getLogger(InboxView.class).warn("drop error", (Throwable)e);
                                }
                                ++n2;
                            }
                        }
                        InboxView.this.viewer.refresh();
                    } else {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warnung", (String)"Bitte w\u00e4hlen Sie zuerst einen Patienten aus.");
                    }
                }
            }
        });
        this.addFilterActions(menuManager);
        InboxServiceComponent.getService().addUpdateListener(new IInboxUpdateListener(){

            public void update(final InboxElement element) {
                if (InboxView.this.viewer != null && !InboxView.this.viewer.getControl().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InboxView.this.contentProvider.refreshElement(element);
                            InboxView.this.viewer.refresh();
                        }
                    });
                }
            }
        });
        this.reload();
        MenuManager ctxtMenuManager = new MenuManager();
        Menu menu = ctxtMenuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(ctxtMenuManager, (ISelectionProvider)this.viewer);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.mandantChanged});
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setAutoSelectPatientState(CoreHub.userCfg.get("inbox/patient/autoselect", false));
    }

    public void setAutoSelectPatientState(boolean value) {
        this.setAutoSelectPatient = value;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("at.medevit.elexis.inbox.ui.autoSelectPatient");
        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)value);
        CoreHub.userCfg.set("inbox/patient/autoselect", value);
    }

    private void addFilterActions(ToolBarManager menuManager) {
        InboxElementUiExtension extension = new InboxElementUiExtension();
        List<IInboxElementUiProvider> providers = extension.getProviders();
        for (IInboxElementUiProvider iInboxElementUiProvider : providers) {
            ViewerFilter extensionFilter = iInboxElementUiProvider.getFilter();
            if (extensionFilter == null) continue;
            InboxFilterAction action = new InboxFilterAction((StructuredViewer)this.viewer, extensionFilter, iInboxElementUiProvider.getFilterImage());
            menuManager.add((IAction)action);
        }
        menuManager.update(true);
    }

    private IInboxElementService.State toggleInboxElementState(InboxElement inboxElement) {
        if (inboxElement.getState() == IInboxElementService.State.NEW) {
            inboxElement.setState(IInboxElementService.State.SEEN);
            return IInboxElementService.State.SEEN;
        }
        if (inboxElement.getState() == IInboxElementService.State.SEEN) {
            inboxElement.setState(IInboxElementService.State.NEW);
            return IInboxElementService.State.NEW;
        }
        return IInboxElementService.State.NEW;
    }

    public void setFocus() {
        this.filterText.setFocus();
        if (this.reloadPending) {
            this.reload();
        }
    }

    private List<InboxElement> getOpenInboxElements() {
        List openElements = InboxServiceComponent.getService().getInboxElements((Mandant)ElexisEventDispatcher.getSelected(Mandant.class), null, IInboxElementService.State.NEW);
        return openElements;
    }

    public void reload() {
        if (!this.viewer.getControl().isVisible()) {
            this.reloadPending = true;
            return;
        }
        this.viewer.setInput(this.getOpenInboxElements());
        this.reloadPending = false;
        this.viewer.refresh();
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.mandantChanged});
        super.dispose();
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.viewer;
    }

    private class InboxElementViewerFilter
    extends ViewerFilter {
        protected String searchString;
        protected LabelProvider labelProvider = new InboxElementLabelProvider();

        private InboxElementViewerFilter() {
        }

        public void setSearchText(String s) {
            this.searchString = s;
        }

        public boolean isActive() {
            return this.searchString != null && !this.searchString.isEmpty();
        }

        private boolean isSelect(Object leaf) {
            String label = this.labelProvider.getText(leaf);
            return label != null && label.contains(this.searchString);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] children = provider.getChildren(element);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return this.isSelect(element);
        }
    }
}

