/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.ui;

import at.medevit.elexis.inbox.core.ui.preferences.InboxPreferences;
import at.medevit.elexis.inbox.model.InboxElement;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.LabResult;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LabResultLabelProvider
extends LabelProvider
implements IColorProvider {
    public Image getImage(Object element) {
        return Images.IMG_VIEW_LABORATORY.getImage();
    }

    public String getText(Object element) {
        PersistentObject object = CoreHub.poFactory.createFromString(((InboxElement)element).get("object"));
        if (object instanceof LabResult) {
            LabResult labResult = (LabResult)object;
            List<LabelFields> labelFields = InboxPreferences.getChoosenLabel();
            StringBuilder sb = new StringBuilder();
            for (LabelFields lblField : labelFields) {
                sb.append(lblField.getValue(labResult));
                sb.append(", ");
            }
            if (!sb.toString().isEmpty() && sb.substring(sb.length() - 2, sb.length()).equals(", ")) {
                sb.replace(sb.length() - 2, sb.length(), "");
            }
            return sb.toString();
        }
        return ((InboxElement)element).getLabel();
    }

    public Color getForeground(Object element) {
        LabResult labResult = (LabResult)((InboxElement)element).getObject();
        if (labResult.isFlag(1)) {
            return Display.getCurrent().getSystemColor(3);
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        return Display.getCurrent().getSystemColor(1);
    }

    public static enum LabelFields {
        LAB_VALUE_SHORT("K\u00fcrzel"),
        LAB_VALUE_NAME("Name"),
        REF_RANGE("Referenzbereich"),
        LAB_RESULT("Resultat"),
        ORIGIN("Herkunft"),
        DATE("Datum");

        private final String text;

        private LabelFields(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static LabelFields getEnum(String value) {
            if (value.equals(LAB_VALUE_SHORT.toString())) {
                return LAB_VALUE_SHORT;
            }
            if (value.equals(LAB_VALUE_NAME.toString())) {
                return LAB_VALUE_NAME;
            }
            if (value.equals(LAB_RESULT.toString())) {
                return LAB_RESULT;
            }
            if (value.equals(REF_RANGE.toString())) {
                return REF_RANGE;
            }
            if (value.equals(ORIGIN.toString())) {
                return ORIGIN;
            }
            if (value.equals(DATE.toString())) {
                return DATE;
            }
            return null;
        }

        public String getValue(LabResult labResult) {
            switch (this) {
                case LAB_VALUE_SHORT: {
                    return labResult.getItem().getKuerzel();
                }
                case LAB_VALUE_NAME: {
                    return labResult.getItem().getName();
                }
                case LAB_RESULT: {
                    return labResult.getResult();
                }
                case REF_RANGE: {
                    return String.valueOf(labResult.getRefMale()) + "/" + labResult.getRefFemale();
                }
                case ORIGIN: {
                    return labResult.getOrigin().getLabel();
                }
                case DATE: {
                    TimeTool observationTime = labResult.getObservationTime();
                    if (observationTime == null) {
                        return labResult.getDate();
                    }
                    return observationTime.toString(4);
                }
            }
            return "";
        }
    }
}

