/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.elements;

import at.medevit.elexis.inbox.core.elements.service.ServiceComponent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLabInboxElement
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AddLabInboxElement.class);
    private static final int MAX_WAIT = 40;
    private LabResult labResult;

    public AddLabInboxElement(LabResult labResult) {
        this.labResult = labResult;
    }

    @Override
    public void run() {
        if (this.labResult.get("PatientID") == null || this.labResult.get("PatientID").isEmpty()) {
            int waitForFields = 0;
            while (waitForFields < 40) {
                try {
                    ++waitForFields;
                    Thread.sleep(500L);
                    if (this.labResult.get("PatientID") == null || this.labResult.get("PatientID").isEmpty()) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (waitForFields == 40) {
                logger.warn(String.format("Could not get data from result [%s].", this.labResult.getId()));
                return;
            }
        }
        Patient patient = this.labResult.getPatient();
        Kontakt doctor = this.labResult.getPatient().getStammarzt();
        Mandant assignedMandant = this.loadAssignedMandant(true);
        if (doctor == null) {
            if (assignedMandant == null) {
                assignedMandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
            }
        } else {
            logger.debug("Creating InboxElement for result [" + this.labResult.getId() + "] and patient " + patient.getLabel() + " for mandant " + doctor.getLabel());
            ServiceComponent.getService().createInboxElement(patient, doctor, (PersistentObject)this.labResult);
        }
        if (assignedMandant != null && !assignedMandant.equals((Object)doctor)) {
            logger.debug("Creating InboxElement for result [" + this.labResult.getId() + "] and patient " + patient.getLabel() + " for mandant " + assignedMandant.getLabel());
            ServiceComponent.getService().createInboxElement(patient, (Kontakt)assignedMandant, (PersistentObject)this.labResult);
        }
    }

    private Mandant loadAssignedMandant(boolean retry) {
        String mandantId;
        List orders = LabOrder.getLabOrders((Patient)this.labResult.getPatient(), null, null, (LabResult)this.labResult, null, null, null);
        if (orders != null && !orders.isEmpty() && (mandantId = ((LabOrder)orders.get(0)).get("mandant")) != null && !mandantId.isEmpty()) {
            return Mandant.load((String)mandantId);
        }
        if (retry) {
            try {
                Thread.sleep(1500L);
                return this.loadAssignedMandant(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }
}

