/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.handlers;

import at.medevit.elexis.impfplan.ui.handlers.progress.ImportLegacyVaccinationsProgress;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Mandant;
import ch.elexis.impfplan.model.Vaccination;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLegacyVaccinationsHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(ImportLegacyVaccinationsHandler.class);
    public static final String COMMAND_ID = "at.medevit.elexis.impfplan.ui.command.ImportOtherVaccinations";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Mandant mandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        IProgressService progService = PlatformUI.getWorkbench().getProgressService();
        ImportLegacyVaccinationsProgress ivProgress = new ImportLegacyVaccinationsProgress(mandant.storeToString());
        try {
            progService.runInUI((IRunnableContext)progService, (IRunnableWithProgress)ivProgress, null);
        }
        catch (Exception e) {
            log.error("Error running ImportVaccinationsProgress", (Throwable)e);
            return "Fehler beim Impf-Import Prozess";
        }
        StringBuilder sb = new StringBuilder();
        if (ivProgress.isAbnormalImport()) {
            List<Vaccination> alreadyImported = ivProgress.getAlreadyImportedVaccinations();
            Map<Vaccination, ImportLegacyVaccinationsProgress.ErrorCode> errorMap = ivProgress.getErrorMap();
            if (!errorMap.isEmpty()) {
                for (Vaccination vacc : errorMap.keySet()) {
                    ImportLegacyVaccinationsProgress.ErrorCode eCode = errorMap.get(vacc);
                    if (eCode.equals((Object)ImportLegacyVaccinationsProgress.ErrorCode.PATIENT_NOTFOUND)) {
                        if (vacc.getPatientId().isEmpty() && vacc.getVaccinationType() == null) {
                            log.warn("Import warn: patientId and vaccinationType is null for vaccination id: " + vacc.getId());
                            continue;
                        }
                        sb.append(String.valueOf(vacc.getPatientId()) + " : " + (vacc.getVaccinationType() != null ? vacc.getVaccinationType().getLabel() : "VaccType [NULL]") + " - " + eCode.toString());
                    } else {
                        sb.append(String.valueOf(vacc.getLabel()) + " - " + eCode.toString());
                    }
                    sb.append("\n");
                }
                if (sb.length() > 0) {
                    sb.insert(0, "Fehler beim Import:\n");
                    sb.append("\n");
                }
            }
            if (!alreadyImported.isEmpty()) {
                sb.append("Bereits importiert:\n");
                for (Vaccination vacc : alreadyImported) {
                    sb.append(vacc.getLabel());
                    sb.append("\n");
                }
            }
        } else {
            sb.append("Import erfolgreich abgeschlossen!");
        }
        return sb.toString();
    }
}

