/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.handlers;

import at.medevit.elexis.impfplan.ui.billing.AddVaccinationToKons;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.codesystems.LeistungenView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyVaccinationHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ApplyVaccinationHandler.class);
    private static boolean inProgress = false;
    private static PersistentObjectDropTarget dropTarget;
    private static TimeTool doa;
    private static Konsultation kons;
    private LeistungenView leistungenView;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (dropTarget == null) {
            dropTarget = new PersistentObjectDropTarget("Impfplan", (Control)UiDesk.getTopShell(), (PersistentObjectDropTarget.IReceiver)new DropReceiver());
        }
        try {
            if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                SWTHelper.alert((String)"Fehler", (String)"LeistungenView.ID");
            }
            this.leistungenView = (LeistungenView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
            CodeSelectorHandler csHandler = CodeSelectorHandler.getInstance();
            csHandler.setCodeSelectorTarget((ICodeSelectorTarget)dropTarget);
            csHandler.getCodeSelectorTarget().registered(false);
            CTabItem[] cTabItemArray = this.leistungenView.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem cti = cTabItemArray[n2];
                if (cti.getText().equalsIgnoreCase("Artikelstamm")) {
                    this.leistungenView.setSelected(cti);
                    this.leistungenView.setFocus();
                    this.leistungenView.ctab.setSelection(cti);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("Error trying to open LeistungenView", (Throwable)e);
        }
        return null;
    }

    public static Date getKonsDate() {
        doa = new TimeTool(kons.getDatum());
        return doa.getTime();
    }

    public static boolean inProgress() {
        return inProgress;
    }

    private final class DropReceiver
    implements PersistentObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        public void dropped(PersistentObject o, DropTargetEvent ev) {
            Artikel artikel;
            String atcCode;
            if (o instanceof Artikel && (atcCode = (artikel = (Artikel)o).getATC_code()) != null && atcCode.length() > 4 && atcCode.toUpperCase().startsWith("J07")) {
                AddVaccinationToKons addVacToKons = new AddVaccinationToKons(ElexisEventDispatcher.getSelectedPatient(), artikel, artikel.getEAN());
                kons = addVacToKons.findOrCreateKons();
                if (kons == null) {
                    logger.warn("Could not insert vaccination as no consultation was found for this patient");
                    SWTHelper.showError((String)"Nicht erstellbar", (String)"Konnte Impfung nich eintragen, da keine Konsultation vorhanden ist.");
                }
                inProgress = true;
            }
        }

        public boolean accept(PersistentObject o) {
            return ElexisEventDispatcher.getSelectedPatient() != null && o instanceof Artikel;
        }
    }
}

