/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.dialogs;

import at.medevit.elexis.impfplan.model.DiseaseDefinitionModel;
import at.medevit.elexis.impfplan.ui.VaccinationEffectCheckboxTreeViewer;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.proposals.PersistentObjectContentProposal;
import ch.elexis.core.ui.proposals.PersistentObjectProposalProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class SupplementVaccinationDialog
extends TitleAreaDialog {
    private Text txtAdministrator;
    private Text txtArticleName;
    private Text txtLotNo;
    private Text txtAtcCode;
    private Text txtArticleEAN;
    private VaccinationEffectCheckboxTreeViewer vect;
    private boolean isSupplement = false;
    private String administratorString = null;
    private String articleString = null;
    private DateTime dateOfAdministration;
    private String articleEAN;
    private String vaccAgainst;
    private String articleAtcCode;
    private String lotNo;
    private GregorianCalendar doa;
    private Mandant mandant;
    private TimeTool patBDay;
    private TimeTool selDate;
    private Patient pat;

    public SupplementVaccinationDialog(Shell parentShell, Patient pat) {
        super(parentShell);
        this.pat = pat;
        this.mandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        this.patBDay = new TimeTool(pat.getGeburtsdatum());
        this.selDate = new TimeTool();
        this.isSupplement = true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Impfung nachtragen");
        this.setTitleImage(ResourceManager.getPluginImage("at.medevit.elexis.impfplan.ui", "rsc/icons/vaccination_logo.png"));
        Patient selectedPatient = ElexisEventDispatcher.getSelectedPatient();
        this.setMessage(this.pat.getLabel());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Group mainGroup = new Group(container, 0);
        mainGroup.setFont(SWTResourceManager.getFont("Noto Sans", 9, 1));
        mainGroup.setText("Pflicht Angaben");
        GridLayout gd_MainGroup = new GridLayout(2, false);
        mainGroup.setLayout((Layout)gd_MainGroup);
        mainGroup.setLayoutData((Object)new GridData(1808));
        Label lblVerabreichungsdatum = new Label((Composite)mainGroup, 0);
        lblVerabreichungsdatum.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVerabreichungsdatum.setText("Datum");
        this.dateOfAdministration = new DateTime((Composite)mainGroup, 2052);
        this.dateOfAdministration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SupplementVaccinationDialog.this.selDate.set(SupplementVaccinationDialog.this.dateOfAdministration.getYear(), SupplementVaccinationDialog.this.dateOfAdministration.getMonth(), SupplementVaccinationDialog.this.dateOfAdministration.getDay());
                if (SupplementVaccinationDialog.this.selDate.isBefore(SupplementVaccinationDialog.this.patBDay)) {
                    SWTHelper.showInfo((String)"Patient noch nicht geboren", (String)"Das von Ihnen gew\u00e4hlte Datum liegt vor der Geburt des Patienten.");
                    SupplementVaccinationDialog.this.dateOfAdministration.setYear(SupplementVaccinationDialog.this.patBDay.get(1));
                    SupplementVaccinationDialog.this.dateOfAdministration.setMonth(SupplementVaccinationDialog.this.patBDay.get(2));
                    SupplementVaccinationDialog.this.dateOfAdministration.setDay(SupplementVaccinationDialog.this.patBDay.get(5));
                }
            }
        });
        Label lblArtikelname = new Label((Composite)mainGroup, 0);
        lblArtikelname.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblArtikelname.setText("Artikelname");
        this.txtArticleName = new Text((Composite)mainGroup, 2048);
        this.txtArticleName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtArticleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SupplementVaccinationDialog.this.articleString = SupplementVaccinationDialog.this.txtArticleName.getText();
            }
        });
        PersistentObjectProposalProvider aopp = new PersistentObjectProposalProvider(ArtikelstammItem.class, "ATC", "LIKE", "J07%");
        ContentProposalAdapter articleProposalAdapter = new ContentProposalAdapter((Control)this.txtArticleName, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)aopp, null, null);
        articleProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                PersistentObjectContentProposal prop = (PersistentObjectContentProposal)proposal;
                SupplementVaccinationDialog.this.txtArticleName.setText(prop.getLabel());
                SupplementVaccinationDialog.this.articleString = ((ArtikelstammItem)prop.getPersistentObject()).storeToString();
            }
        });
        new Label(container, 0);
        Group optionalGroup = new Group(container, 0);
        optionalGroup.setFont(SWTResourceManager.getFont("Noto Sans", 9, 1));
        optionalGroup.setText("Optionale Angaben");
        optionalGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        optionalGroup.setLayout((Layout)new GridLayout(2, false));
        Label lblAdministratingContact = new Label((Composite)optionalGroup, 0);
        lblAdministratingContact.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAdministratingContact.setText("Nachtrag von");
        this.txtAdministrator = new Text((Composite)optionalGroup, 2048);
        this.administratorString = this.mandant.storeToString();
        this.txtAdministrator.setText(this.mandant.getMandantLabel());
        this.txtAdministrator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SupplementVaccinationDialog.this.administratorString = SupplementVaccinationDialog.this.txtAdministrator.getText();
            }
        });
        this.txtAdministrator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        PersistentObjectProposalProvider<Mandant> mopp = new PersistentObjectProposalProvider<Mandant>(Mandant.class){

            public String getLabelForObject(Mandant a) {
                return a.getMandantLabel();
            }
        };
        ContentProposalAdapter mandatorProposalAdapter = new ContentProposalAdapter((Control)this.txtAdministrator, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)mopp, null, null);
        mandatorProposalAdapter.setProposalAcceptanceStyle(2);
        mandatorProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                PersistentObjectContentProposal prop = (PersistentObjectContentProposal)proposal;
                SupplementVaccinationDialog.this.administratorString = ((Mandant)prop.getPersistentObject()).storeToString();
            }
        });
        Label lblLotNo = new Label((Composite)optionalGroup, 0);
        lblLotNo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLotNo.setText("Lot-Nr");
        this.txtLotNo = new Text((Composite)optionalGroup, 2048);
        this.txtLotNo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group expiredGroup = new Group(container, 0);
        expiredGroup.setFont(SWTResourceManager.getFont("Noto Sans", 9, 1));
        expiredGroup.setText("Bei nicht mehr erh\u00e4ltlichen Impfstoffen");
        expiredGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        expiredGroup.setLayout((Layout)new GridLayout(2, false));
        Label lblVaccAgainst = new Label((Composite)expiredGroup, 0);
        lblVaccAgainst.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblVaccAgainst.setText("Impfung gegen Krankheit(en)");
        this.vect = new VaccinationEffectCheckboxTreeViewer(container, 2048, this.vaccAgainst);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.lotNo = this.txtLotNo.getText();
        this.doa = new GregorianCalendar(this.dateOfAdministration.getYear(), this.dateOfAdministration.getMonth(), this.dateOfAdministration.getDay());
        this.vaccAgainst = this.vect.getCheckedElementsAsCommaSeparatedString();
        super.okPressed();
    }

    public TimeTool getDateOfAdministration() {
        return new TimeTool(this.doa.getTime());
    }

    public String getAdministratorString() {
        return this.administratorString;
    }

    public String getLotNo() {
        return this.lotNo;
    }

    public String getAtcCode() {
        return this.articleAtcCode;
    }

    public String getArticleString() {
        return this.articleString;
    }

    public String getEAN() {
        return this.articleEAN;
    }

    public boolean isSupplement() {
        return this.isSupplement;
    }

    public String getVaccAgainst() {
        return this.vaccAgainst;
    }

    private class DiseaseTreeContentProvider
    implements ITreeContentProvider {
        private DiseaseTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return DiseaseDefinitionModel.getDiseaseDefinitions().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return (DiseaseDefinitionModel.DiseaseDefinition)element;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class DiseaseTreeLabelProvider
    implements ILabelProvider {
        private DiseaseTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((DiseaseDefinitionModel.DiseaseDefinition)element).getDiseaseLabel();
        }
    }
}

