/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.dialogs;

import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.impfplan.ui.VaccinationEffectCheckboxTreeViewer;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.proposals.PersistentObjectContentProposal;
import ch.elexis.core.ui.proposals.PersistentObjectProposalProvider;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class EditVaccinationDialog
extends TitleAreaDialog {
    private Vaccination vacc;
    private Text txtAdministrator;
    private String administratorString;
    private Text txtLotNo;
    private DateTime dateTimeDOA;
    private VaccinationEffectCheckboxTreeViewer vect;

    public EditVaccinationDialog(Shell parentShell, Vaccination vacc) {
        super(parentShell);
        this.vacc = vacc;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Angaben zur Impfung \u00e4ndern");
        this.setTitleImage(ResourceManager.getPluginImage("at.medevit.elexis.impfplan.ui", "rsc/icons/vaccination_logo.png"));
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        this.setMessage(sp != null ? sp.getLabel() : "missing patient name");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblAdministratingContact = new Label(container, 0);
        lblAdministratingContact.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAdministratingContact.setText("Verabreicht von");
        this.txtAdministrator = new Text(container, 2048);
        this.administratorString = this.vacc.get("administrator");
        this.txtAdministrator.setText(this.vacc.getAdministratorLabel());
        this.txtAdministrator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditVaccinationDialog.this.administratorString = EditVaccinationDialog.this.txtAdministrator.getText();
            }
        });
        this.txtAdministrator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        PersistentObjectProposalProvider<Mandant> mopp = new PersistentObjectProposalProvider<Mandant>(Mandant.class){

            public String getLabelForObject(Mandant a) {
                return a.getMandantLabel();
            }
        };
        ContentProposalAdapter mandatorProposalAdapter = new ContentProposalAdapter((Control)this.txtAdministrator, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)mopp, null, null);
        mandatorProposalAdapter.setProposalAcceptanceStyle(2);
        mandatorProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                PersistentObjectContentProposal prop = (PersistentObjectContentProposal)proposal;
                EditVaccinationDialog.this.administratorString = ((Mandant)prop.getPersistentObject()).storeToString();
            }
        });
        Label lblLotNo = new Label(container, 0);
        lblLotNo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLotNo.setText("Lot-Nr");
        this.txtLotNo = new Text(container, 2048);
        this.txtLotNo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtLotNo.setText(this.vacc.getLotNo());
        Label lblVerabreichungsdatum = new Label(container, 0);
        lblVerabreichungsdatum.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVerabreichungsdatum.setAlignment(131072);
        lblVerabreichungsdatum.setText("Verabreichungsdatum");
        this.dateTimeDOA = new DateTime(container, 2048);
        TimeTool doa = this.vacc.getDateOfAdministration();
        this.dateTimeDOA.setDate(doa.get(1), doa.get(2), doa.get(5));
        if (this.vacc.get("Artikel_REF").length() == 0) {
            Label lblImpfungGegen = new Label(container, 0);
            lblImpfungGegen.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
            lblImpfungGegen.setAlignment(131072);
            lblImpfungGegen.setText("Impfung gegen");
            this.vect = new VaccinationEffectCheckboxTreeViewer(container, 2048, this.vacc.get("vaccAgainst"));
            this.vect.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        }
        return area;
    }

    protected void okPressed() {
        this.vacc.setAdministratorString(this.administratorString);
        this.vacc.setLotNo(this.txtLotNo.getText());
        Calendar instance = Calendar.getInstance();
        instance.set(5, this.dateTimeDOA.getDay());
        instance.set(2, this.dateTimeDOA.getMonth());
        instance.set(1, this.dateTimeDOA.getYear());
        this.vacc.setDateOfAdministration(instance.getTime());
        if (this.vect != null) {
            this.vacc.setVaccAgainst(this.vect.getCheckedElementsAsCommaSeparatedString());
        }
        super.okPressed();
    }
}

