/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import java.util.Optional;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class ApplicationInputDialog
extends TitleAreaDialog {
    private static final String DEF_SIDE = "left";
    private boolean showSideOption = CoreHub.userCfg.get("plugins/impfplan/showside", false);
    private String lotNo;
    private String side;
    private Text txtLotNo;
    private Button btnLeft;
    private Button btnRight;
    private Optional<Artikel> art;

    public ApplicationInputDialog(Shell parentShell, Artikel article) {
        super(parentShell);
        this.art = Optional.ofNullable(article);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Impfungsdetails");
        this.setTitleImage(ResourceManager.getPluginImage("at.medevit.elexis.impfplan.ui", "rsc/icons/vaccination_logo.png"));
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        this.setMessage(sp != null ? sp.getLabel() : "missing patient name");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite containerLotNo = new Composite(area, 0);
        containerLotNo.setLayout((Layout)new GridLayout(2, false));
        containerLotNo.setLayoutData((Object)new GridData(1808));
        Label lblLotNo = new Label(containerLotNo, 0);
        lblLotNo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblLotNo.setText("Lot-Nummer f\u00fcr Impfstoff angeben");
        Label lblArticleName = new Label(containerLotNo, 0);
        lblArticleName.setAlignment(0x1000000);
        lblArticleName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)lblArticleName.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)lblArticleName.getDisplay());
        lblArticleName.setFont(boldFont);
        lblArticleName.setText(this.art.isPresent() ? this.art.get().getLabel() : "Artikel nicht gefunden");
        Label lblP = new Label(containerLotNo, 0);
        lblP.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtLotNo = new Text(containerLotNo, 2048);
        this.txtLotNo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.showSideOption) {
            Composite containerSide = new Composite(area, 0);
            containerSide.setLayout((Layout)new GridLayout(2, false));
            containerSide.setLayoutData((Object)new GridData(1808));
            Label lblSide = new Label(containerSide, 0);
            lblSide.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            lblSide.setText("Impfung wurde auf folgender Seite verabreicht");
            this.btnLeft = new Button(containerSide, 16);
            this.btnLeft.setText("links");
            this.btnRight = new Button(containerSide, 16);
            this.btnRight.setText("rechts");
            if (DEF_SIDE.equals(CoreHub.userCfg.get("plugins/impfplan/defaultside", DEF_SIDE))) {
                this.btnLeft.setSelection(true);
            } else {
                this.btnRight.setSelection(true);
            }
        }
        return area;
    }

    protected void okPressed() {
        this.lotNo = this.txtLotNo.getText();
        if (this.showSideOption) {
            this.side = this.btnLeft.getSelection() ? this.btnLeft.getText() : this.btnRight.getText();
        }
        super.okPressed();
    }

    public String getLotNo() {
        return this.lotNo;
    }

    public String getSide() {
        return this.side;
    }
}

