/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.billing;

import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.impfplan.ui.dialogs.ApplicationInputDialog;
import at.medevit.elexis.impfplan.ui.handlers.ApplyVaccinationHandler;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IVerrechnetAdjuster;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VaccinationVerrechnetAdjuster
implements IVerrechnetAdjuster {
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void adjust(final Verrechnet verrechnet) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                String atc_code;
                IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                if (verrechenbar instanceof Artikel && (atc_code = ((Artikel)verrechenbar).getATC_code()) != null && atc_code.length() > 4 && atc_code.toUpperCase().startsWith("J07")) {
                    Patient patient;
                    Fall fall;
                    Konsultation kons = verrechnet.getKons();
                    if (kons != null && (fall = kons.getFall()) != null && (patient = fall.getPatient()) != null) {
                        VaccinationVerrechnetAdjuster.this.performVaccination(patient.getId(), (Artikel)verrechenbar);
                    }
                    verrechnet.setDetail("vat_scale", Double.toString(0.0));
                }
            }
        });
    }

    private void performVaccination(final String patientId, final Artikel article) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Date d = new Date();
                if (ApplyVaccinationHandler.inProgress()) {
                    d = ApplyVaccinationHandler.getKonsDate();
                }
                Mandant m = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
                ApplicationInputDialog aid = new ApplicationInputDialog(UiDesk.getTopShell(), article);
                aid.open();
                String lotNo = aid.getLotNo();
                String side = aid.getSide();
                Vaccination vacc = new Vaccination(patientId, article, d, lotNo, m.storeToString());
                if (side != null && !side.isEmpty()) {
                    vacc.setSide(side);
                }
            }
        });
    }

    public void adjustGetNettoPreis(Verrechnet verrechnet, Money price) {
    }
}

