/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.billing;

import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.dialogs.SelectOrCreateOpenKonsDialog;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class AddVaccinationToKons {
    private static final String TARMED_5MIN_TARIF = "00.0010";
    private static Object selectKonsLock = new Object();
    private Konsultation kons;
    private Patient patient;
    private Artikel art;

    public AddVaccinationToKons(Patient patient, Artikel art, String ean) {
        this.patient = patient;
        this.art = art;
        if (art == null) {
            art = ArtikelstammItem.findByEANorGTIN((String)ean);
        }
    }

    public Konsultation findOrCreateKons() {
        this.initKonsultation();
        if (this.kons == null || !this.kons.isEditable(false)) {
            return null;
        }
        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)this.kons, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                AddVaccinationToKons.this.kons.addLeistung((IVerrechenbar)AddVaccinationToKons.this.art);
                Samdas samdas = new Samdas(AddVaccinationToKons.this.kons.getEintrag().getHead());
                Samdas.Record rec = samdas.getRecord();
                String recText = rec.getText();
                recText = String.valueOf(recText) + "\nImpfung - " + AddVaccinationToKons.this.art.getName();
                rec.setText(recText);
                AddVaccinationToKons.this.kons.updateEintrag(samdas.toString(), true);
                boolean addedCons = true;
                List leistungen = AddVaccinationToKons.this.kons.getLeistungen();
                for (Verrechnet verrechnet : leistungen) {
                    IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                    if (verrechenbar == null || !verrechenbar.getCodeSystemName().equals("Tarmed") || !verrechenbar.getCode().equals(AddVaccinationToKons.TARMED_5MIN_TARIF)) continue;
                    addedCons = false;
                    break;
                }
                IVerrechenbar consVerrechenbar = AddVaccinationToKons.this.getKonsVerrechenbar(AddVaccinationToKons.this.kons);
                if (addedCons && consVerrechenbar != null) {
                    AddVaccinationToKons.this.kons.addLeistung(consVerrechenbar);
                }
            }
        });
        return this.kons;
    }

    private IVerrechenbar getKonsVerrechenbar(Konsultation kons) {
        TimeTool date = new TimeTool(kons.getDatum());
        if (kons.getFall() != null) {
            BillingLaw law = kons.getFall().getConfiguredBillingSystemLaw();
            return TarmedLeistung.getFromCode((String)TARMED_5MIN_TARIF, (TimeTool)date, (String)law.name());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKonsultation() {
        Object object = selectKonsLock;
        synchronized (object) {
            this.kons = this.patient.getLetzteKons(false);
            if (this.kons == null || !this.kons.isEditable(false)) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectOrCreateOpenKonsDialog dialog = new SelectOrCreateOpenKonsDialog(AddVaccinationToKons.this.patient, "Konsultation f\u00fcr die automatische Verrechnung ausw\u00e4hlen.");
                        if (dialog.open() == 0) {
                            AddVaccinationToKons.this.kons = dialog.getKonsultation();
                        }
                    }
                });
            }
        }
    }
}

