/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui;

import at.medevit.elexis.impfplan.model.ArticleToImmunisationModel;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.impfplan.model.vaccplans.ImpfplanSchweiz2015;
import at.medevit.elexis.impfplan.ui.VaccinationComposite;
import at.medevit.elexis.impfplan.ui.VaccinationCompositePaintListener;
import at.medevit.elexis.impfplan.ui.VaccinationPlanHeaderDefinition;
import at.medevit.elexis.impfplan.ui.dialogs.EditVaccinationDialog;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class VaccinationView
extends ViewPart {
    public static final String PART_ID = "at.medevit.elexis.impfplan.ui.ImpfplanViewPart";
    private static VaccinationPlanHeaderDefinition vaccinationHeaderDefinition;
    private static List<Vaccination> vaccinations;
    private VaccinationComposite vaccinationComposite;
    private VaccinationCompositePaintListener vcPaintListener;
    public static final String HEADER_ID_SHOW_ADMINISTERED = "HISA";
    private Patient pat;
    private boolean sortByVaccinationName = false;
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            VaccinationView.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
        }
    };
    private ElexisEventListener eeli_vacc = new ElexisUiEventListenerImpl(Vaccination.class, 3){

        public void runInUi(ElexisEvent ev) {
            VaccinationView.this.updateUi(true);
        }
    };
    private ScrolledComposite scrolledComposite;

    public VaccinationView() {
        ImpfplanSchweiz2015 is = new ImpfplanSchweiz2015();
        vaccinationHeaderDefinition = new VaccinationPlanHeaderDefinition(is.id, is.name, is.getOrderedBaseDiseases(), is.getOrderedExtendedDiseases());
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_vacc});
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        this.vaccinationComposite = new VaccinationComposite((Composite)this.scrolledComposite);
        this.scrolledComposite.setContent((Control)this.vaccinationComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.vaccinationComposite.computeSize(-1, -1));
        this.vcPaintListener = this.vaccinationComposite.getVaccinationCompositePaintListener();
        this.vaccinationComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Vaccination selVaccination = VaccinationView.this.vcPaintListener.getSelectedVaccination();
                VaccinationView.this.editVaccination(selVaccination);
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Eintrag l\u00f6schen";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                Vaccination selVaccination = VaccinationView.this.vcPaintListener.getSelectedVaccination();
                if (selVaccination != null) {
                    selVaccination.delete();
                }
            }
        });
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Impfung editieren";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT.getImageDescriptor();
            }

            public void run() {
                Vaccination selVaccination = VaccinationView.this.vcPaintListener.getSelectedVaccination();
                VaccinationView.this.editVaccination(selVaccination);
            }
        });
        this.vaccinationComposite.setMenu(menuManager.createContextMenu((Control)this.vaccinationComposite));
        this.getSite().registerContextMenu("at.medevit.elexis.impfplan.ui.ImpfplanViewPart.contextMenu", menuManager, (ISelectionProvider)this.vaccinationComposite);
        this.getSite().setSelectionProvider((ISelectionProvider)this.vaccinationComposite);
        if (ElexisEventDispatcher.getSelectedPatient() != null) {
            this.setPatient(ElexisEventDispatcher.getSelectedPatient());
        }
    }

    private void editVaccination(Vaccination selVaccination) {
        if (selVaccination != null) {
            EditVaccinationDialog evd = new EditVaccinationDialog(this.vaccinationComposite.getShell(), selVaccination);
            evd.open();
        }
    }

    private void setPatient(Patient selectedPatient) {
        this.pat = selectedPatient;
        this.updateUi(true);
    }

    public void updateUi(boolean patientChanged) {
        if (this.pat == null) {
            vaccinations = Collections.emptyList();
            return;
        }
        if (patientChanged) {
            boolean sortDir = CoreHub.userCfg.get("plugins/impfplan/sortorder", false);
            Query qbe = new Query(Vaccination.class);
            qbe.add("ID", "<>", "VERSION");
            qbe.add("Patient_ID", "=", this.pat.getId());
            qbe.orderBy(sortDir, new String[]{"dateOfAdministration"});
            vaccinations = qbe.execute();
        }
        if (this.sortByVaccinationName) {
            this.sortVaccinationsByName();
        }
        if (VaccinationView.vaccinationHeaderDefinition.id.equals(HEADER_ID_SHOW_ADMINISTERED)) {
            HashSet<String> atc = new HashSet<String>();
            for (Vaccination vacc : vaccinations) {
                String atcCode = vacc.get("ATCCode");
                if (atcCode.length() > 3) {
                    List immunisationForAtcCode = ArticleToImmunisationModel.getImmunisationForAtcCode((String)atcCode);
                    atc.addAll(immunisationForAtcCode);
                    continue;
                }
                atc.addAll(Arrays.asList(vacc.get("vaccAgainst").split(",")));
            }
            vaccinationHeaderDefinition = new VaccinationPlanHeaderDefinition(HEADER_ID_SHOW_ADMINISTERED, "Nur verabreichte Impfungen", new ArrayList<String>(atc), Collections.emptyList());
        }
        this.vaccinationComposite.updateUi(vaccinationHeaderDefinition, vaccinations, new TimeTool(this.pat.getGeburtsdatum()));
        if (patientChanged) {
            this.vaccinationComposite.update();
            this.vaccinationComposite.redraw();
        }
    }

    public void sortVaccinationsByName() {
        Collections.sort(vaccinations, new Comparator<Vaccination>(){

            @Override
            public int compare(Vaccination vac1, Vaccination vac2) {
                String name1 = vac1.getShortBusinessName();
                String name2 = vac2.getShortBusinessName();
                return name1.compareTo(name2);
            }
        });
    }

    public void setSortByVaccinationName(boolean sort) {
        this.sortByVaccinationName = sort;
        this.updateUi(!sort);
    }

    public void setFocus() {
        this.updateUi(false);
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_vacc});
        super.dispose();
    }

    public static void setVaccinationHeaderDefinition(VaccinationPlanHeaderDefinition vacccinationHeaderDefinition) {
        vaccinationHeaderDefinition = vacccinationHeaderDefinition;
        IViewReference viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(PART_ID);
        IWorkbenchPart part = viewReference.getPart(false);
        if (part != null) {
            part.setFocus();
        }
    }

    public static VaccinationPlanHeaderDefinition getVaccinationHeaderDefinition() {
        return vaccinationHeaderDefinition;
    }

    public VaccinationComposite getVaccinationComposite() {
        return this.vaccinationComposite;
    }
}

