/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui;

import at.medevit.elexis.impfplan.model.DiseaseDefinitionModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class VaccinationEffectCheckboxTreeViewer
extends CheckboxTreeViewer
implements ICheckStateProvider {
    private String initialCheckedElements = "";

    public VaccinationEffectCheckboxTreeViewer(Composite parent, int style, String initialCheckedElements) {
        super(parent, style);
        this.initialCheckedElements = initialCheckedElements != null ? initialCheckedElements : "";
        GridData gd_tree = new GridData(4, 128, true, false);
        gd_tree.heightHint = 200;
        this.getTree().setLayoutData((Object)gd_tree);
        this.getTree().setHeaderVisible(false);
        this.getTree().setLinesVisible(true);
        TreeViewerColumn col = new TreeViewerColumn((TreeViewer)this, 0);
        col.getColumn().setWidth(225);
        this.setContentProvider((IContentProvider)new DiseaseTreeContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DiseaseTreeLabelProvider());
        this.setInput(DiseaseDefinitionModel.getDiseaseDefinitions());
        this.setCheckStateProvider(this);
    }

    public String getCheckedElementsAsCommaSeparatedString() {
        Object[] checkedElements = this.getCheckedElements();
        List<Object> list = Arrays.asList(checkedElements);
        Optional<String> ret = list.stream().map(o -> (DiseaseDefinitionModel.DiseaseDefinition)o).map(o -> o.getATCCode()).reduce((u, t) -> String.valueOf(u) + "," + t);
        return ret.orElse("");
    }

    public boolean isChecked(Object element) {
        DiseaseDefinitionModel.DiseaseDefinition dd = (DiseaseDefinitionModel.DiseaseDefinition)element;
        return this.initialCheckedElements.contains(dd.getATCCode());
    }

    public boolean isGrayed(Object element) {
        return false;
    }

    private class DiseaseTreeContentProvider
    implements ITreeContentProvider {
        private DiseaseTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return DiseaseDefinitionModel.getDiseaseDefinitions().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return (DiseaseDefinitionModel.DiseaseDefinition)element;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class DiseaseTreeLabelProvider
    implements ILabelProvider {
        private DiseaseTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((DiseaseDefinitionModel.DiseaseDefinition)element).getDiseaseLabel();
        }
    }
}

