/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.ui;

import at.medevit.elexis.gdt.data.GDTProtokoll;
import at.medevit.elexis.gdt.ui.table.util.ColumnBuilder;
import at.medevit.elexis.gdt.ui.table.util.IValue;
import at.medevit.elexis.gdt.ui.table.util.IValueFormatter;
import at.medevit.elexis.gdt.ui.table.util.SortColumnComparator;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;

public class GDTProtokollView
extends ViewPart {
    public static final String ID = "at.medevit.elexis.gdt.ui.GDTProtokollView";
    private TableViewer tableViewer;
    private Table table;
    private ElexisEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            GDTProtokollView.this.reload();
        }
    };

    public GDTProtokollView() {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
    }

    public void reload() {
        if (!this.table.isVisible()) {
            return;
        }
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null) {
            this.tableViewer.setInput((Object)GDTProtokoll.getEntriesForPatient(pat));
        }
    }

    public void createPartControl(Composite parent) {
        this.initTableViewer(parent);
        ColumnBuilder messageDirection = this.createColumn("");
        messageDirection.bindToProperty("messageDirection");
        messageDirection.format(new ColumnBuilder.ICellFormatter(){

            @Override
            public void formatCell(ViewerCell cell, Object value) {
                String direction = (String)value;
                cell.setText("");
                if (direction.equalsIgnoreCase("IN")) {
                    cell.setImage(ResourceManager.getPluginImage("at.medevit.elexis.gdt", "rsc/icons/incoming.png"));
                } else if (direction.equalsIgnoreCase("OUT")) {
                    cell.setImage(ResourceManager.getPluginImage("at.medevit.elexis.gdt", "rsc/icons/outgoing.png"));
                }
            }
        });
        messageDirection.setPixelWidth(23);
        messageDirection.build();
        ColumnBuilder entryTime = this.createColumn("Datum/Uhrzeit");
        entryTime.bindToProperty("entryTime");
        entryTime.format(new IValueFormatter<TimeTool, String>(){

            @Override
            public String format(TimeTool obj) {
                return obj.toString(0);
            }

            @Override
            public TimeTool parse(String obj) {
                return new TimeTool(obj);
            }
        });
        entryTime.setPercentWidth(15);
        entryTime.useAsDefaultSortColumn();
        entryTime.build();
        ColumnBuilder gdtSatz = this.createColumn("Satzart");
        gdtSatz.bindToValue(new BaseValue<GDTProtokoll>(this){

            @Override
            public Object get(GDTProtokoll entry) {
                return entry.get("MessageType");
            }
        });
        gdtSatz.setPercentWidth(5);
        gdtSatz.build();
        ColumnBuilder bezeichnung = this.createColumn("Bezeichnung");
        bezeichnung.bindToProperty("bezeichnung");
        bezeichnung.makeEditable();
        bezeichnung.setPercentWidth(25);
        bezeichnung.build();
        ColumnBuilder bemerkungen = this.createColumn("Bemerkungen");
        bemerkungen.bindToProperty("bemerkungen");
        bemerkungen.makeEditable();
        bemerkungen.setPercentWidth(25);
        bemerkungen.build();
        ColumnBuilder patient = this.createColumn("Patient");
        patient.bindToProperty("entryRelatedPatient");
        patient.format(new IValueFormatter<Patient, String>(){

            @Override
            public String format(Patient obj) {
                return obj.getLabel();
            }

            @Override
            public Patient parse(String obj) {
                return null;
            }
        });
        patient.setPercentWidth(10);
        patient.build();
        ColumnBuilder gegenstelle = this.createColumn("Gegenstelle");
        gegenstelle.bindToProperty("gegenstelle");
        gegenstelle.setPercentWidth(15);
        gegenstelle.build();
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(null);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.table.setMenu(menuManager.createContextMenu((Control)this.table));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
    }

    private void initTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.table = this.tableViewer.getTable();
        this.table.getParent().setLayout((Layout)new TableColumnLayout());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setComparator((ViewerComparator)new SortColumnComparator());
    }

    public void setFocus() {
        this.reload();
    }

    public ColumnBuilder createColumn(String columnHeaderText) {
        return new ColumnBuilder(this.tableViewer, columnHeaderText);
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
        super.dispose();
    }

    public abstract class BaseValue<T>
    implements IValue {
        @Override
        public final Object getValue(Object element) {
            return this.get(element);
        }

        @Override
        public void setValue(Object element, Object value) {
            this.set(element, value);
        }

        public abstract Object get(T var1);

        public Object set(T element, Object value) {
            throw new UnsupportedOperationException("Overwrite value.set() to set values!");
        }
    }
}

