/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.tools;

import at.medevit.elexis.gdt.handler.GDTFileInputHandler;
import at.medevit.elexis.gdt.tools.GDTFileHelper;
import ch.elexis.core.data.activator.CoreHub;
import ch.rgw.tools.Log;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class DirectoryWatcher
implements FileAlterationListener {
    private List<File> directories;
    private FileAlterationObserver observer;
    private FileAlterationMonitor monitor;
    private static DirectoryWatcher instance = null;
    private Log logger = Log.get((String)DirectoryWatcher.class.getName());
    private List<FileAlterationObserver> observers = new LinkedList<FileAlterationObserver>();

    private DirectoryWatcher() {
        this.directories = new LinkedList<File>();
        this.monitor = new FileAlterationMonitor(2000L);
        this.monitor.addObserver(this.observer);
    }

    public static DirectoryWatcher getInstance() {
        if (instance == null) {
            instance = new DirectoryWatcher();
        }
        return instance;
    }

    public void addDirectoryToWatch(File directory) {
        if (directory.isDirectory()) {
            this.logger.log("Adding directory: " + directory, 5);
            FileAlterationObserver observer = new FileAlterationObserver(directory);
            this.directories.add(directory);
            observer.addListener((FileAlterationListener)this);
            this.observers.add(observer);
            this.monitor.addObserver(observer);
            this.unwatch();
            this.watch();
        } else {
            this.logger.log("Invalid directory entry passed: " + directory, 5);
        }
    }

    public void watch() {
        this.logger.log("Watching " + this.observers.size() + " directories.", 5);
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            this.logger.log(e.getMessage(), 4);
        }
        for (File directory : this.directories) {
            LinkedList files = (LinkedList)FileUtils.listFiles((File)directory, null, (boolean)false);
            Collections.sort(files, new DateTimeAscending());
            for (File file : files) {
                this.processFile(file);
            }
        }
    }

    public void unwatch() {
        this.logger.log("Unwatching " + this.observers.size() + " directories.", 5);
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            this.logger.log(e.getMessage(), 4);
        }
    }

    public void onFileCreate(File file) {
        this.logger.log("Incoming file " + file, 5);
        this.processFile(file);
    }

    private void processFile(File file) {
        if (GDTFileHelper.containsSatzNachricht(file)) {
            GDTFileInputHandler.handle(file);
        } else if (CoreHub.localCfg.get("GDT/fileTransferDeleteNonGDT", false)) {
            boolean success = file.delete();
            if (success) {
                this.logger.log("Deleted non GDT file " + file, 5);
            } else {
                this.logger.log("Error deleting file " + file, 3);
            }
        }
    }

    public void onFileChange(File arg0) {
    }

    public void onFileDelete(File arg0) {
    }

    public void onDirectoryChange(File arg0) {
    }

    public void onDirectoryCreate(File arg0) {
    }

    public void onDirectoryDelete(File arg0) {
    }

    public void onStart(FileAlterationObserver arg0) {
    }

    public void onStop(FileAlterationObserver arg0) {
    }

    private final class DateTimeAscending
    implements Comparator<File> {
        private DateTimeAscending() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            if (FileUtils.isFileNewer((File)arg0, (File)arg1)) {
                return 1;
            }
            if (FileUtils.isFileOlder((File)arg1, (File)arg0)) {
                return -1;
            }
            return 0;
        }
    }
}

