/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.messages;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class GDTSatzNachricht {
    static final String CRLF = "\r\n";
    LinkedList<String> message = null;
    HashMap<Integer, String> values = new LinkedHashMap<Integer, String>();
    int charCounterSatzLaenge = 0;
    DecimalFormat threePlaces = new DecimalFormat("000");
    DecimalFormat fivePlaces = new DecimalFormat("00000");

    public GDTSatzNachricht(int satzart, String gdtIdReceiver, String gdtIdSender, String zeichensatz, String gdtVersion) {
        this.values.put(8000, String.valueOf(satzart));
        this.values.put(8315, gdtIdReceiver);
        this.values.put(8316, gdtIdSender);
        this.values.put(9206, zeichensatz);
        this.values.put(9218, gdtVersion);
    }

    protected void addLine(String str) {
        int length = str.length();
        length += this.threePlaces.format(length).length();
        String line = String.valueOf(this.threePlaces.format(length += CRLF.length())) + str + CRLF;
        this.message.add(line);
        this.charCounterSatzLaenge += line.length();
    }

    protected void addLine(int feldkennung) {
        this.addLine(String.valueOf(feldkennung) + this.values.get(feldkennung));
    }

    protected void ifSetAddLine(int feldkennung) {
        if (this.values.get(feldkennung) != null) {
            this.addLine(feldkennung);
        }
    }

    protected void createMessage() {
        this.addLine(8000);
        this.ifSetAddLine(8315);
        this.ifSetAddLine(8316);
        this.ifSetAddLine(9206);
        this.ifSetAddLine(9218);
    }

    public String getValue(int feldkennung) {
        return this.values.get(feldkennung);
    }

    public void setValue(int feldkennung, String value) {
        this.values.put(feldkennung, value);
    }

    public HashMap<Integer, String> getValues() {
        return this.values;
    }

    public void setValues(HashMap<Integer, String> values) {
        this.values = values;
    }

    public String[] getMessage() {
        if (this.message == null) {
            this.message = new LinkedList();
            this.createMessage();
            this.finalizeMessage();
        }
        return this.message.toArray(new String[0]);
    }

    protected void finalizeMessage() {
        this.charCounterSatzLaenge += 14;
        String line = "0148100" + this.fivePlaces.format(this.charCounterSatzLaenge) + CRLF;
        this.message.add(1, line);
    }
}

