/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.data;

import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class GDTProtokoll
extends PersistentObject {
    public static final String FLD_DATETIME = "DateTime";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_BEZEICHNUNG = "Bezeichnung";
    public static final String FLD_BEMERKUNGEN = "Bemerkungen";
    public static final String FLD_MESSAGE_TYPE = "MessageType";
    public static final String FLD_MESSAGE_DIRECTION = "MessageDirection";
    public static final String FLD_GEGENSTELLE = "Remote";
    public static final String FLD_MESSAGE = "Message";
    static final String VERSION = "1.0.1";
    public static final String MESSAGE_DIRECTION_IN = "IN";
    public static final String MESSAGE_DIRECTION_OUT = "OUT";
    static final String TABLENAME = "at_medevit_elexis_gdt_protokoll";
    static final String createDB = "CREATE TABLE at_medevit_elexis_gdt_protokoll(ID VARCHAR(25) primary key,lastupdate BIGINT,deleted CHAR(1) default '0',DateTime VARCHAR(24),PatientID VARCHAR(25),Bezeichnung VARCHAR(60),Bemerkungen VARCHAR(80),MessageType VARCHAR(4),MessageDirection VARCHAR(3),Remote VARCHAR(60),Message\tTEXT);CREATE INDEX at_medevit_elexis_gdt_protokollidx1 on at_medevit_elexis_gdt_protokoll (DateTime);INSERT INTO at_medevit_elexis_gdt_protokoll (ID,DateTime) VALUES ('VERSION'," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        GDTProtokoll.addMapping((String)TABLENAME, (String[])new String[]{FLD_DATETIME, FLD_PATIENT_ID, FLD_BEZEICHNUNG, FLD_BEMERKUNGEN, FLD_MESSAGE_TYPE, FLD_MESSAGE_DIRECTION, FLD_GEGENSTELLE, FLD_MESSAGE});
        GDTProtokoll version = GDTProtokoll.load("VERSION");
        if (!version.exists()) {
            GDTProtokoll.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_DATETIME));
            if (vi.isOlder(VERSION)) {
                GDTProtokoll.createOrModifyTable((String)"ALTER TABLE at_medevit_elexis_gdt_protokoll MODIFY Remote VARCHAR(255);");
                version.set(FLD_DATETIME, VERSION);
            }
        }
    }

    GDTProtokoll() {
    }

    protected GDTProtokoll(String id) {
        super(id);
    }

    public <U extends GDTSatzNachricht> GDTProtokoll(String messageDirection, IGDTCommunicationPartner cp, U satzNachricht) {
        this.create(null);
        Patient pat = Patient.loadByPatientID((String)satzNachricht.getValue(3000));
        StringBuilder sb = new StringBuilder();
        String[] message = satzNachricht.getMessage();
        int i = 0;
        while (i < message.length) {
            sb.append(message[i]);
            ++i;
        }
        this.set(new String[]{FLD_DATETIME, FLD_PATIENT_ID, FLD_MESSAGE_TYPE, FLD_MESSAGE_DIRECTION, FLD_GEGENSTELLE, FLD_MESSAGE, FLD_BEZEICHNUNG}, new String[]{new TimeTool().toString(13), pat != null ? pat.getId() : "nicht zugeordnet", satzNachricht.getValue(8000), messageDirection, cp.getLabel(), sb.toString(), satzNachricht.getValue(8410)});
        int satznachrichtType = Integer.parseInt(satzNachricht.getValue(8000));
        if (messageDirection.equalsIgnoreCase(MESSAGE_DIRECTION_OUT)) {
            switch (satznachrichtType) {
                case 6302: {
                    this.set(FLD_BEZEICHNUNG, "Anforderung Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
                case 6311: {
                    this.set(FLD_BEZEICHNUNG, "Anzeige Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
                case 6301: {
                    this.set(FLD_BEZEICHNUNG, "Stammdaten \u00fcbermittelt");
                    break;
                }
            }
        }
        if (messageDirection.equalsIgnoreCase(MESSAGE_DIRECTION_IN)) {
            switch (satznachrichtType) {
                case 6310: {
                    this.set(FLD_BEZEICHNUNG, "Resultat Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
            }
        }
    }

    public static GDTProtokoll load(String id) {
        return new GDTProtokoll(id);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        TimeTool tt = new TimeTool(this.get(FLD_DATETIME));
        Patient pat = Patient.loadByPatientID((String)this.get(FLD_PATIENT_ID));
        sb.append(String.valueOf(tt.toString(4)) + ": " + pat.getLabel() + " " + FLD_MESSAGE_TYPE + " " + FLD_MESSAGE_DIRECTION);
        return sb.toString();
    }

    public String getMenuLabel() {
        StringBuilder sb = new StringBuilder();
        TimeTool tt = new TimeTool(this.get(FLD_DATETIME));
        sb.append(String.valueOf(tt.toString(4)) + ": " + this.get(FLD_BEZEICHNUNG) + " " + "[" + this.get(FLD_GEGENSTELLE) + "]");
        return sb.toString();
    }

    public static <U extends GDTSatzNachricht> GDTProtokoll addEntry(String messageDirection, IGDTCommunicationPartner cp, U satzNachricht) {
        return new GDTProtokoll(messageDirection, cp, satzNachricht);
    }

    public static GDTProtokoll[] getAllEntries() {
        Query qbe = new Query(GDTProtokoll.class);
        qbe.add("ID", "<>", "VERSION");
        List qre = qbe.execute();
        return qre.toArray(new GDTProtokoll[0]);
    }

    public static GDTProtokoll[] getEntriesForPatient(Patient pat) {
        String ID = pat.getId();
        Query qbe = new Query(GDTProtokoll.class);
        qbe.add("ID", "<>", "VERSION");
        qbe.add(FLD_PATIENT_ID, "=", ID);
        List qre = qbe.execute();
        return qre.toArray(new GDTProtokoll[0]);
    }

    public String getMessageDirection() {
        return this.get(FLD_MESSAGE_DIRECTION);
    }

    public TimeTool getEntryTime() {
        return new TimeTool(this.get(FLD_DATETIME));
    }

    public String getMessageType() {
        return this.get(FLD_MESSAGE_TYPE);
    }

    public Patient getEntryRelatedPatient() {
        return Patient.load((String)this.get(FLD_PATIENT_ID));
    }

    public String getBezeichnung() {
        return this.get(FLD_BEZEICHNUNG);
    }

    public void setBezeichnung(String bezeichnung) {
        this.set(FLD_BEZEICHNUNG, bezeichnung);
    }

    public String getBemerkungen() {
        return this.get(FLD_BEMERKUNGEN);
    }

    public void setBemerkungen(String bemerkung) {
        this.set(FLD_BEMERKUNGEN, bemerkung);
    }

    public String getGegenstelle() {
        return this.get(FLD_GEGENSTELLE);
    }

    public String getMessage() {
        return this.get(FLD_MESSAGE);
    }
}

