/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt;

import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.tools.DirectoryWatcher;
import at.medevit.elexis.gdt.tools.GDTCommPartnerCollector;
import ch.elexis.core.ui.util.Log;
import java.io.File;
import java.util.List;
import org.eclipse.ui.IStartup;

public class EarlyStartup
implements IStartup {
    private static Log logger = Log.get((String)EarlyStartup.class.getName());

    public void earlyStartup() {
        List<IGDTCommunicationPartner> lp = GDTCommPartnerCollector.getRegisteredCommPartners();
        if (lp == null) {
            logger.log("There are no registered communication partners", 5);
            return;
        }
        for (IGDTCommunicationPartner igdtCommunicationPartner : lp) {
            if (igdtCommunicationPartner.getConnectionType() != 2) continue;
            String incomingDirString = igdtCommunicationPartner.getIncomingDirectory();
            logger.log("Found directory " + incomingDirString + "to watch by comm partner " + igdtCommunicationPartner.getLabel(), 5);
            File incomingDir = null;
            if (incomingDirString != null) {
                incomingDir = new File(incomingDirString);
            }
            if (incomingDir == null || !incomingDir.isDirectory()) continue;
            DirectoryWatcher.getInstance().addDirectoryToWatch(incomingDir);
        }
    }
}

