/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.defaultfilecp.ui.view;

import at.medevit.elexis.gdt.data.GDTProtokoll;
import at.medevit.elexis.gdt.defaultfilecp.FileCommPartner;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class GdtView
extends ViewPart {
    private Map<String, Button> mapExaminations = new HashMap<String, Button>();
    private Composite composite;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            GdtView.this.refreshLastExaminations();
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.composite = new Composite((Composite)sc, 0);
        this.composite.setLayout((Layout)new GridLayout());
        sc.setContent((Control)this.composite);
        this.createContents(this.composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.composite.computeSize(-1, -1));
    }

    private void createContents(Composite composite) {
        this.mapExaminations.clear();
        String[] stringArray = FileCommPartner.getAllFileCommPartnersArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            FileCommPartner fileCommPartner = new FileCommPartner(id);
            String fileCommPartnerName = fileCommPartner.getSettings().get(fileCommPartner.getFileTransferName(), "");
            String lastExaminationId = this.getLastExaminationId(fileCommPartner);
            Composite content = new Composite(composite, 2048);
            content.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
            content.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(content, 131072);
            label.setText("");
            label.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            label.setBackground(UiDesk.getColor((String)"hellgrau"));
            label = new Label(content, 0);
            label.setText("Ger\u00e4t: " + fileCommPartnerName);
            label.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            Button btnNewExamination = new Button(content, 8);
            btnNewExamination.setText("");
            btnNewExamination.setImage(Images.IMG_SYSTEM_MONITOR.getImage());
            btnNewExamination.setToolTipText("Neue Untersuchung anfordern");
            btnNewExamination.setData((Object)fileCommPartner.getId());
            btnNewExamination.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ElexisEventDispatcher.getSelectedPatient() == null) {
                        GdtView.this.openPatientNotSelectedDialog();
                    } else {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = commandService.getCommand("at.medevit.elexis.gdt.command.NeueUntersuchungAnfordern");
                        if (command != null) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("at.medevit.elexis.gdt.cmd.parameter.targetId", String.valueOf(((Button)event.getSource()).getData()));
                            ExecutionEvent ee = new ExecutionEvent(command, params, null, (Object)GdtView.this.getSite().getPage());
                            try {
                                command.executeWithChecks(ee);
                            }
                            catch (CommandException e) {
                                LoggerFactory.getLogger(GdtView.class).error("command execution", (Throwable)e);
                                GdtView.this.openPatientNotSelectedDialog();
                            }
                        }
                    }
                }
            });
            Button btnBaseDataRequest = new Button(content, 8);
            btnBaseDataRequest.setText("");
            btnBaseDataRequest.setImage(Images.IMG_USER_IDLE.getImage());
            btnBaseDataRequest.setToolTipText("Stammdaten \u00fcbermitteln");
            btnBaseDataRequest.setData((Object)fileCommPartner.getId());
            btnBaseDataRequest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ElexisEventDispatcher.getSelectedPatient() == null) {
                        GdtView.this.openPatientNotSelectedDialog();
                    } else {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = commandService.getCommand("at.medevit.elexis.gdt.command.StammdatenUebermitteln");
                        if (command != null) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("at.medevit.elexis.gdt.cmd.parameter.targetId", String.valueOf(((Button)event.getSource()).getData()));
                            ExecutionEvent ee = new ExecutionEvent(command, params, null, (Object)GdtView.this.getSite().getPage());
                            try {
                                command.executeWithChecks(ee);
                            }
                            catch (CommandException e) {
                                LoggerFactory.getLogger(GdtView.class).error("command execution", (Throwable)e);
                                MessageDialog.openError((Shell)GdtView.this.getSite().getShell(), (String)"Error", (String)"Stammdaten\u00fcbermittlung fehlgeschlagen.");
                            }
                        }
                    }
                }
            });
            String lastExaminationToolTip = "Letzte Untersuchung anzeigen";
            Composite lastExaminationComposite = new Composite(content, 0);
            lastExaminationComposite.setLayout((Layout)new GridLayout(1, false));
            lastExaminationComposite.setToolTipText(lastExaminationToolTip);
            Button btnShowLastExamination = new Button(lastExaminationComposite, 8);
            btnShowLastExamination.setText("");
            btnShowLastExamination.setToolTipText(lastExaminationToolTip);
            btnShowLastExamination.setImage(Images.IMG_EYE_WO_SHADOW.getImage());
            btnShowLastExamination.setData((Object)lastExaminationId);
            btnShowLastExamination.setEnabled(lastExaminationId != null);
            btnShowLastExamination.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("at.medevit.elexis.gdt.command.DatenEinerUntersuchungAnzeigen");
                    if (command != null) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("at.medevit.elexis.gdt.command.DatenEinerUntersuchungAnzeigen.gdtProtokollSource", String.valueOf(((Button)event.getSource()).getData()));
                        ExecutionEvent ee = new ExecutionEvent(command, params, null, (Object)GdtView.this.getSite().getPage());
                        try {
                            command.executeWithChecks(ee);
                        }
                        catch (CommandException e) {
                            LoggerFactory.getLogger(GdtView.class).error("command execution", (Throwable)e);
                            MessageDialog.openError((Shell)GdtView.this.getSite().getShell(), (String)"Error", (String)"Letzte Untersuchung anzeigen fehlgeschlagen.");
                        }
                    }
                }
            });
            if (id != null) {
                this.mapExaminations.put(id, btnShowLastExamination);
            }
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
            ++n2;
        }
    }

    public void setFocus() {
    }

    private String getLabel(FileCommPartner fileCommPartner) {
        return String.valueOf(fileCommPartner.getSettings().get(fileCommPartner.getFileTransferName(), "")) + " (" + fileCommPartner.getSettings().get(fileCommPartner.getFileTransferDirectory(), "") + ")";
    }

    private void openPatientNotSelectedDialog() {
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Kein Patient ausgew\u00e4hlt.");
    }

    public String getLastExaminationId(FileCommPartner fileCommPartner) {
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null) {
            GDTProtokoll[] prot;
            String label = this.getLabel(fileCommPartner);
            GDTProtokoll[] gDTProtokollArray = prot = GDTProtokoll.getEntriesForPatient((Patient)pat);
            int n = prot.length;
            int n2 = 0;
            while (n2 < n) {
                GDTProtokoll gdtProtokoll = gDTProtokollArray[n2];
                if (Integer.parseInt(gdtProtokoll.getMessageType()) == 6310 && label.equals(gdtProtokoll.getGegenstelle())) {
                    return gdtProtokoll.getId();
                }
                ++n2;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
    }

    private void refreshLastExaminations() {
        if (this.mapExaminations != null) {
            for (String id : this.mapExaminations.keySet()) {
                Button btn = this.mapExaminations.get(id);
                if (btn == null) continue;
                String exId = this.getLastExaminationId(new FileCommPartner(id));
                btn.setData((Object)exId);
                btn.setEnabled(exId != null);
            }
            if (this.composite != null) {
                this.composite.layout(true);
            }
        }
    }
}

