/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.defaultfilecp.ui;

import at.medevit.elexis.gdt.defaultfilecp.FileCommPartner;
import at.medevit.elexis.gdt.defaultfilecp.ui.FileCommPartnerComposite;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GDTPreferencePageFileTransfer
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite editorParent;
    List<FileCommPartnerComposite> fileCommPartnerComposites = new ArrayList<FileCommPartnerComposite>();

    public GDTPreferencePageFileTransfer() {
        this.setTitle("Datei-Kommunikation");
    }

    protected Control createContents(Composite parent) {
        this.fileCommPartnerComposites.clear();
        this.editorParent = new Composite(parent, 0);
        this.editorParent.setLayout((Layout)new GridLayout(3, false));
        Button btnCfg = new Button(this.editorParent, 32);
        btnCfg.setText("Dateisystem Einstellungen global speichern");
        btnCfg.setSelection(FileCommPartner.isFileTransferGlobalConfigured());
        btnCfg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                FileCommPartner.setFileTransferConfiguration(button.getSelection());
                Control[] controlArray = GDTPreferencePageFileTransfer.this.editorParent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof FileCommPartnerComposite) {
                        c.dispose();
                    }
                    ++n2;
                }
                GDTPreferencePageFileTransfer.this.createContent();
                GDTPreferencePageFileTransfer.this.editorParent.layout(true, true);
            }
        });
        this.createContent();
        return this.editorParent;
    }

    private void createContent() {
        ScrolledComposite scrolledComposite = this.findScrolledComposite();
        String[] stringArray = FileCommPartner.getAllFileCommPartnersArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.createNewFileCommPartnerComposite(id, null, scrolledComposite);
            ++n2;
        }
    }

    public void createNewFileCommPartnerComposite(String id, String name, ScrolledComposite scrolledComposite) {
        FileCommPartner fileCommPartner = new FileCommPartner(id);
        if (name != null) {
            fileCommPartner.getSettings().set(fileCommPartner.getFileTransferName(), name);
        }
        this.fileCommPartnerComposites.add(new FileCommPartnerComposite((IPreferencePage)this, scrolledComposite, this.editorParent, fileCommPartner));
    }

    private ScrolledComposite findScrolledComposite() {
        Composite parent = this.editorParent;
        int i = 0;
        while (i < 10) {
            if ((parent = parent.getParent()) instanceof ScrolledComposite) {
                return (ScrolledComposite)parent;
            }
            ++i;
        }
        return null;
    }

    public boolean performOk() {
        for (FileCommPartnerComposite fileCommPartnerComposite : this.fileCommPartnerComposites) {
            fileCommPartnerComposite.save();
        }
        CoreHub.userCfg.flush();
        CoreHub.globalCfg.flush();
        CoreHub.localCfg.flush();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(FileCommPartner.isFileTransferGlobalConfigured() ? CoreHub.globalCfg : CoreHub.localCfg));
    }
}

