/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.epha.interactions.utils;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EphaSearchAction
extends Action
implements IKonsExtension,
IHandler {
    public static final Logger logger = LoggerFactory.getLogger(EphaSearchAction.class);
    public static final String ID = "at.medevit.elexis.epha.interactions.EphaSearchAction";
    private static EphaSearchAction instance;

    public String connect(IRichTextDisplay tf) {
        return ID;
    }

    public EphaSearchAction() {
        super("Medikamenteninteraktion pr\u00fcfen ...");
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        return false;
    }

    public boolean doXRef(String refProvider, String refID) {
        return false;
    }

    public void run() {
        StringBuilder sb = new StringBuilder();
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        if (sp == null) {
            return;
        }
        List medication = sp.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
        for (Prescription prescription : medication) {
            if (prescription.getArtikel() == null) {
                logger.warn("Article of prescription ID=" + prescription.getId() + " not valid");
                continue;
            }
            String ean = prescription.getArtikel().getEAN();
            if (ean == null || ean.isEmpty() || ean.length() < 9) {
                logger.warn("Could not get EAN for aritcle with id " + prescription.getArtikel().getId());
                continue;
            }
            if (sb.length() == 0) {
                sb.append(ean);
                continue;
            }
            sb.append("," + ean);
        }
        String url = "https://epha.ch/matrix/visual/gtin:" + sb.toString() + "/";
        Program.launch((String)url);
    }

    public IAction[] getActions() {
        return new IAction[]{this};
    }

    public void insert(Object o, int pos) {
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (instance != null) {
            instance.run();
        }
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

