/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.ui.handler;

import at.medevit.elexis.emediplan.core.EMediplanServiceHolder;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medicament;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.core.model.chmed16a.Posology;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectImportHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String emediplan = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.emediplan");
        String patientid = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.patientid");
        final String stopreason = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.stopreason");
        String medicationType = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.medication");
        if (medicationType == null || medicationType.isEmpty()) {
            medicationType = "all";
        }
        if (StringUtils.isNotEmpty((CharSequence)patientid) && StringUtils.isNotEmpty((CharSequence)emediplan)) {
            Medication medication = EMediplanServiceHolder.getService().createModelFromChunk(emediplan);
            EMediplanServiceHolder.getService().addExistingArticlesToMedication(medication);
            Patient patient = Patient.load((String)patientid);
            if (patient.exists()) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)patient);
                List<Prescription> currentMedication = this.getPrescriptions(patient, medicationType);
                for (final Prescription prescription : currentMedication) {
                    AcquireLockUi.aquireAndRun((IPersistentObject)prescription, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            prescription.stop(null);
                            prescription.setStopReason(stopreason != null ? stopreason : "Direct Import");
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)prescription, Prescription.class, 4)});
                        }
                    });
                }
                ArrayList<Medicament> notFoundMedicament = new ArrayList<Medicament>();
                for (Medicament medicament : medication.Medicaments) {
                    if (medicament.artikelstammItem != null) {
                        this.createPrescription(medicament, patient);
                        continue;
                    }
                    notFoundMedicament.add(medicament);
                }
                if (!notFoundMedicament.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Folgende Medikamente konnte im Artikelstamm nicht gefunden werden\n\n");
                    notFoundMedicament.forEach(m -> {
                        StringBuilder stringBuilder2 = sb.append(" - " + this.getDsc((Medicament)m) + " " + m.AppInstr + " " + m.TkgRsn);
                    });
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)sb.toString());
                }
            }
        }
        return null;
    }

    private String getDsc(Medicament medicament) {
        String ret = medicament.Id;
        if (StringUtils.isNotBlank((CharSequence)EMediplanServiceHolder.getService().getPFieldValue(medicament, "Dsc"))) {
            ret = EMediplanServiceHolder.getService().getPFieldValue(medicament, "Dsc");
        }
        return ret;
    }

    private List<Prescription> getPrescriptions(Patient patient, String medicationType) {
        if ("all".equals(medicationType)) {
            ArrayList<Prescription> ret = new ArrayList<Prescription>();
            ret.addAll(patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION}));
            ret.addAll(patient.getMedication(new EntryType[]{EntryType.RESERVE_MEDICATION}));
            ret.addAll(patient.getMedication(new EntryType[]{EntryType.SYMPTOMATIC_MEDICATION}));
            return ret;
        }
        if ("fix".equals(medicationType)) {
            return patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
        }
        if ("reserve".equals(medicationType)) {
            return patient.getMedication(new EntryType[]{EntryType.RESERVE_MEDICATION});
        }
        if ("symptomatic".equals(medicationType)) {
            return patient.getMedication(new EntryType[]{EntryType.SYMPTOMATIC_MEDICATION});
        }
        return Collections.emptyList();
    }

    private Prescription createPrescription(Medicament medicament, Patient patient) {
        block4: {
            block2: {
                String takingScheme;
                block3: {
                    medicament.entryType = EntryType.FIXED_MEDICATION;
                    takingScheme = EMediplanServiceHolder.getService().getPFieldValue(medicament, "TkgSch");
                    if (!StringUtils.isNotBlank((CharSequence)takingScheme)) break block2;
                    if (!"Prd".equals(takingScheme)) break block3;
                    medicament.entryType = EntryType.SYMPTOMATIC_MEDICATION;
                    break block4;
                }
                if (!"Ond".equals(takingScheme)) break block4;
                medicament.entryType = EntryType.RESERVE_MEDICATION;
                break block4;
            }
            if (medicament.Pos != null && !medicament.Pos.isEmpty()) {
                for (Posology pos : medicament.Pos) {
                    if (pos.InRes != 1) continue;
                    medicament.entryType = EntryType.RESERVE_MEDICATION;
                }
            }
        }
        Prescription prescription = new Prescription((Artikel)medicament.artikelstammItem, patient, medicament.dosis, medicament.AppInstr);
        prescription.set(new String[]{"prescType", "DateFrom", "DateUntil"}, new String[]{String.valueOf(medicament.entryType.numericValue()), medicament.dateFrom, medicament.dateTo});
        prescription.setDisposalComment(medicament.TkgRsn);
        CoreHub.getLocalLockService().acquireLock((IPersistentObject)prescription);
        CoreHub.getLocalLockService().releaseLock((IPersistentObject)prescription);
        return prescription;
    }
}

