/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.ui;

import at.medevit.elexis.emediplan.Startup;
import at.medevit.elexis.emediplan.core.EMediplanServiceHolder;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medicament;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.ui.CustomMessageDialog;
import at.medevit.elexis.emediplan.ui.QuestionComposite;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.LoggerFactory;

public class ImportEMediplanDialog
extends TitleAreaDialog {
    private final Medication medication;
    private TableViewer tableViewer;
    private Table table;
    private boolean showInboxBtn = true;
    private ElexisEventListener eeli_presc = new ElexisUiEventListenerImpl(Prescription.class, 7){

        public void runInUi(ElexisEvent ev) {
            String patientId;
            Prescription prescription;
            if (((ImportEMediplanDialog)ImportEMediplanDialog.this).medication.Patient != null && (prescription = (Prescription)ev.getObject()) != null && prescription.getArtikel() instanceof ArtikelstammItem && (patientId = prescription.get("PatientID")) != null && patientId.equals(((ImportEMediplanDialog)ImportEMediplanDialog.this).medication.Patient.patientId)) {
                ImportEMediplanDialog.this.refreshMedicamentsTable();
            }
        }
    };

    private void refreshMedicamentsTable() {
        if (this.medication != null) {
            for (Medicament medicament : this.medication.Medicaments) {
                EMediplanServiceHolder.getService().setPresciptionsToMedicament(this.medication, medicament);
            }
        }
        this.tableViewer.refresh();
    }

    public ImportEMediplanDialog(Shell parentShell, Medication medication, boolean showInboxBtn) {
        super(parentShell);
        this.setShellStyle(2160);
        this.medication = medication;
        this.showInboxBtn = showInboxBtn;
    }

    public void create() {
        super.create();
        this.setTitle("eMediplan Import");
        if (this.medication.Patient != null) {
            this.setMessage("Patient: " + this.medication.Patient.patientLabel + "\nMedikamente (Fix, Reserve, Symptomatisch) f\u00fcr den Import ausw\u00e4hlen.");
        }
    }

    protected Control createDialogArea(Composite parent) {
        List<Medicament> input = this.getInput();
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(area, 68354);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 200;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.table = this.tableViewer.getTable();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createColumns(parent);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.getInput());
        Composite c1 = new Composite(parent, 0x4000000);
        c1.setLayoutData((Object)new GridData(4, 4, true, true));
        c1.setLayout((Layout)new GridLayout(2, false));
        Button btnImport = new Button(c1, 8);
        btnImport.setText("Importieren");
        btnImport.setLayoutData((Object)new GridData(0x1000000, 1024, false, false, 1, 1));
        btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEMediplanDialog.this.insertArticle(new StructuredSelection(ImportEMediplanDialog.this.getInput().stream().filter(m -> m.entryType != null).collect(Collectors.toList())));
            }
        });
        Button button = new Button(c1, 8);
        button.setVisible(this.showInboxBtn);
        button.setText("In Inbox ablegen");
        button.setLayoutData((Object)new GridData(0x1000000, 1024, false, false, 1, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int stateMask = e.stateMask;
                if ((stateMask & 0x20000) == 131072 && ((ImportEMediplanDialog)ImportEMediplanDialog.this).medication.chunk != null) {
                    File userDir = CoreHub.getWritableUserDir();
                    File jsonOutput = new File(userDir, "emediplan.json");
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (FileWriter writer = new FileWriter(jsonOutput);){
                            writer.write(Startup.getDecodedJsonString(((ImportEMediplanDialog)ImportEMediplanDialog.this).medication.chunk));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e1) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not write emediplan json" + e);
                    }
                }
                if (EMediplanServiceHolder.getService().createInboxEntry(ImportEMediplanDialog.this.medication, ElexisEventDispatcher.getSelectedMandator())) {
                    MessageDialog.openInformation((Shell)ImportEMediplanDialog.this.getShell(), (String)"Medikationsplan", (String)"Der Medikationsplan wurde erfolgreich in die Inbox hinzugef\u00fcgt.");
                    ImportEMediplanDialog.this.close();
                } else {
                    MessageDialog.openError((Shell)ImportEMediplanDialog.this.getShell(), (String)"Medikationsplan", (String)"Der Medikationsplan konnte nicht in die Inbox hinzugef\u00fcgt werden.\n\u00dcberpr\u00fcfen Sie das LOG File.");
                }
            }
        });
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_presc});
        return area;
    }

    public boolean close() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_presc});
        return super.close();
    }

    private List<Medicament> getInput() {
        return this.medication.Medicaments;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"Fix", "Reserve", "Symptomatisch", "Medikament", "Dosis", "Von Bis", "Anwendungsinstruktion", "Anwendungsgrund"};
        int[] bounds = new int[]{40, 40, 40, 220, 120, 150, 150, 150};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new EmulatedCheckBoxLabelProvider(){

            @Override
            protected boolean isChecked(Object element) {
                Medicament mdm = (Medicament)element;
                return EntryType.FIXED_MEDICATION.equals((Object)mdm.entryType);
            }
        });
        col.setEditingSupport((EditingSupport)new CheckBoxColumnEditingSupport(this.tableViewer, EntryType.FIXED_MEDICATION));
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new EmulatedCheckBoxLabelProvider(){

            @Override
            protected boolean isChecked(Object element) {
                Medicament mdm = (Medicament)element;
                return EntryType.RESERVE_MEDICATION.equals((Object)mdm.entryType);
            }
        });
        col.setEditingSupport((EditingSupport)new CheckBoxColumnEditingSupport(this.tableViewer, EntryType.RESERVE_MEDICATION));
        col = this.createTableViewerColumn(titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new EmulatedCheckBoxLabelProvider(){

            @Override
            protected boolean isChecked(Object element) {
                Medicament mdm = (Medicament)element;
                return EntryType.SYMPTOMATIC_MEDICATION.equals((Object)mdm.entryType);
            }
        });
        col.setEditingSupport((EditingSupport)new CheckBoxColumnEditingSupport(this.tableViewer, EntryType.SYMPTOMATIC_MEDICATION));
        col = this.createTableViewerColumn(titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Medicament mdm = (Medicament)element;
                if (mdm.artikelstammItem != null) {
                    return mdm.artikelstammItem.getName();
                }
                if (StringUtils.isNotBlank((CharSequence)EMediplanServiceHolder.getService().getPFieldValue(mdm, "Dsc"))) {
                    return EMediplanServiceHolder.getService().getPFieldValue(mdm, "Dsc");
                }
                return mdm.Id;
            }

            public Color getBackground(Object element) {
                if (element instanceof Medicament) {
                    Medicament medicament = (Medicament)element;
                    if (medicament.artikelstammItem == null) {
                        return UiDesk.getColorFromRGB((String)"FFDDDD");
                    }
                    if (Medicament.State.GTIN_SAME_DOSAGE.equals((Object)medicament.state)) {
                        return UiDesk.getColorFromRGB((String)"D3D3D3");
                    }
                    if (Medicament.State.ATC.equals((Object)medicament.state)) {
                        return UiDesk.getColorFromRGB((String)"FFDDDD");
                    }
                    if (Medicament.State.ATC_SAME.equals((Object)medicament.state) || Medicament.State.ATC_SAME_DOSAGE.equals((Object)medicament.state)) {
                        return UiDesk.getColorFromRGB((String)"FFDDDD");
                    }
                    if (Medicament.State.GTIN_SAME.equals((Object)medicament.state)) {
                        return UiDesk.getColorFromRGB((String)"FFFEC3");
                    }
                }
                return UiDesk.getColorFromRGB((String)"FFFFFF");
            }

            public String getToolTipText(Object element) {
                if (element instanceof Medicament) {
                    Medicament medicament = (Medicament)element;
                    return medicament.stateInfo;
                }
                return super.getToolTipText(element);
            }

            public Color getForeground(Object element) {
                Medicament medicament;
                if (element instanceof Medicament && (medicament = (Medicament)element).isMedicationExpired()) {
                    return UiDesk.getColor((String)"rot");
                }
                return super.getForeground(element);
            }
        });
        col = this.createTableViewerColumn(titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Medicament mdm = (Medicament)element;
                return mdm.dosis;
            }
        });
        col = this.createTableViewerColumn(titles[5], bounds[5], 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Medicament mdm = (Medicament)element;
                StringBuffer buf = new StringBuffer();
                if (mdm.dateFrom != null) {
                    buf.append(mdm.dateFrom);
                }
                if (mdm.dateTo != null) {
                    buf.append("-");
                    buf.append(mdm.dateTo);
                }
                return buf.toString();
            }
        });
        col = this.createTableViewerColumn(titles[6], bounds[6], 6);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Medicament mdm = (Medicament)element;
                return mdm.AppInstr;
            }
        });
        col = this.createTableViewerColumn(titles[7], bounds[7], 7);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Medicament mdm = (Medicament)element;
                return mdm.TkgRsn;
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof TableColumn) {
                    EntryType entryType = null;
                    if ("Fix".equals(e.widget.getData())) {
                        entryType = EntryType.FIXED_MEDICATION;
                    } else if ("Reserve".equals(e.widget.getData())) {
                        entryType = EntryType.RESERVE_MEDICATION;
                    } else if ("Symptomatisch".equals(e.widget.getData())) {
                        entryType = EntryType.SYMPTOMATIC_MEDICATION;
                    }
                    if (entryType != null) {
                        for (Medicament medicament : ImportEMediplanDialog.this.getInput()) {
                            medicament.entryType = entryType;
                        }
                    }
                }
                super.widgetSelected(e);
                ImportEMediplanDialog.this.tableViewer.refresh();
            }
        });
        column.setData((Object)title);
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    public void insertArticle(StructuredSelection selection) {
        boolean bulkInsert = false;
        try {
            if (selection != null) {
                Object[] selections = selection.toArray();
                Patient patient = null;
                if (this.medication.Patient != null && this.medication.Patient.patientId != null && (patient = Patient.load((String)this.medication.Patient.patientId)) != null && !patient.exists()) {
                    patient = null;
                }
                if (patient != null) {
                    ArrayList<Prescription> prescriptions = new ArrayList<Prescription>();
                    Object[] objectArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Prescription prescription;
                        Object selectItem = objectArray[n2];
                        if (selectItem instanceof Medicament && ((Medicament)selectItem).entryType != null && (prescription = this.insertMedicament(patient, (Medicament)selectItem, selections.length > 1)) != null) {
                            prescriptions.add(prescription);
                            if (!bulkInsert && prescriptions.size() > 3) {
                                ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_presc});
                                bulkInsert = true;
                            }
                        }
                        ++n2;
                    }
                    int sizeInserts = prescriptions.size();
                    if (sizeInserts > 0) {
                        StringBuffer buf = new StringBuffer();
                        if (sizeInserts > 1) {
                            buf.append("Folgende Medikamente wurden erfolgreich hinzugef\u00fcgt: ");
                        } else {
                            buf.append("Folgendes Medikament wurde erfolgreich hinzugef\u00fcgt: ");
                        }
                        buf.append("\n\n");
                        for (Prescription prescription : prescriptions) {
                            buf.append(prescription.getArtikel().getName());
                            buf.append("\n");
                        }
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Artikel", (String)buf.toString());
                    } else if (selections.length > 1) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Artikel", (String)"Die ausgew\u00e4hlten Medikamente konnten nicht automatisch hinzugef\u00fcgt werden.\n\nBitte versuchen Sie diese einzeln hinzuzuf\u00fcgen.");
                    } else if (selections.length == 0) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Artikel", (String)"Import kann nicht durchgef\u00fchrt werden.\n\nBitte selektieren Sie zuerst die Medikamente, die importiert werden sollen.");
                    } else if (selections.length == 1 && selections[0] instanceof Medicament && ((Medicament)selections[0]).entryType == null) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Artikel", (String)"Import kann nicht durchgef\u00fchrt werden.\n\nBitte w\u00e4hlen Sie die Medikation aus Fix, Reserve oder Symptomatisch.");
                    }
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Kein Patient ausgew\u00e4hlt.");
                }
            }
        }
        catch (Throwable throwable) {
            if (bulkInsert) {
                this.refreshMedicamentsTable();
                ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_presc});
            }
            throw throwable;
        }
        if (bulkInsert) {
            this.refreshMedicamentsTable();
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_presc});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Prescription insertMedicament(Patient patient, Medicament medicament, boolean multiSelection) {
        if (patient == null) return null;
        if (medicament == null) return null;
        if (medicament.entryType == null) return null;
        EMediplanServiceHolder.getService().setPresciptionsToMedicament(this.medication, medicament);
        if (medicament.artikelstammItem == null) {
            this.openDialogWarning("Das Medikament kann nicht hinzugef\u00fcgt werden.", medicament, multiSelection);
            return null;
        }
        if (Medicament.State.GTIN_SAME_DOSAGE.equals((Object)medicament.state)) {
            this.openDialogWarning("Das Medikament kann nicht zweimal verordnet werden.", medicament, multiSelection);
            return null;
        }
        if (medicament.isMedicationExpired()) {
            this.openDialogWarning("Das Medikament kann nicht hinzugef\u00fcgt werden.", medicament, multiSelection);
            return null;
        }
        if (medicament.foundPrescription == null) return this.createPrescription(medicament, patient, multiSelection);
        return this.insertMedicamentExistingPrescription(patient, medicament, multiSelection);
    }

    private Prescription insertMedicamentExistingPrescription(Patient patient, Medicament medicament, boolean multiSelection) {
        if (multiSelection && Medicament.State.GTIN_SAME.equals((Object)medicament.state)) {
            return null;
        }
        if (multiSelection) {
            return this.createPrescription(medicament, patient, multiSelection);
        }
        QuestionComposite medicationQuestionComposite = new QuestionComposite();
        StringBuffer buf = new StringBuffer();
        buf.append("\n\n");
        if (Medicament.State.GTIN_SAME.equals((Object)medicament.state)) {
            buf.append("Wollen Sie dieses Medikament hinzuf\u00fcgen und die bestehende Medikation historisieren ?");
            medicationQuestionComposite.setDefaulSelection(true);
            medicationQuestionComposite.createQuestionText("Vorhandenes (" + medicament.foundPrescription.getArtikel().getName() + ") stoppen");
        } else {
            buf.append("Wollen Sie dieses Medikament hinzuf\u00fcgen ?");
            medicationQuestionComposite.setDefaulSelection(false);
            if (Medicament.State.ATC_SAME.equals((Object)medicament.state) || Medicament.State.ATC_SAME_DOSAGE.equals((Object)medicament.state)) {
                medicationQuestionComposite.createQuestionText("Vorhandenes (" + medicament.foundPrescription.getArtikel().getName() + ") stoppen");
            }
        }
        if (this.openCustomDialog(medicationQuestionComposite, buf.toString(), medicament) == 0) {
            if (medicationQuestionComposite.isQuestionConfirmed()) {
                medicament.foundPrescription.stop(new TimeTool());
                medicament.foundPrescription.setStopReason("EMediplan Import");
            }
            return this.createPrescription(medicament, patient, multiSelection);
        }
        return null;
    }

    public int openCustomDialog(QuestionComposite medicationQuestionComposite, String text, Medicament medicament) {
        CustomMessageDialog<QuestionComposite> dlg = new CustomMessageDialog<QuestionComposite>(this.getShell(), "Artikel", String.valueOf(medicament.stateInfo) + text, medicationQuestionComposite);
        return dlg.open();
    }

    public void openDialogWarning(String text, Medicament medicament, boolean multiSelection) {
        if (medicament != null && !multiSelection) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Artikel", (String)(String.valueOf(medicament.stateInfo) + "\n\n" + text));
        }
    }

    private Prescription createPrescription(Medicament medicament, Patient patient, boolean multiSelection) {
        Prescription prescription = new Prescription((Artikel)medicament.artikelstammItem, patient, medicament.dosis, medicament.AppInstr);
        prescription.set(new String[]{"prescType", "DateFrom", "DateUntil"}, new String[]{String.valueOf(medicament.entryType.numericValue()), medicament.dateFrom, medicament.dateTo});
        prescription.setDisposalComment(medicament.TkgRsn);
        CoreHub.getLocalLockService().acquireLock((IPersistentObject)prescription);
        CoreHub.getLocalLockService().releaseLock((IPersistentObject)prescription);
        return prescription;
    }

    class CheckBoxColumnEditingSupport
    extends EditingSupport {
        private final TableViewer tableViewer;
        private final EntryType forType;

        public CheckBoxColumnEditingSupport(TableViewer viewer, EntryType forType) {
            super((ColumnViewer)viewer);
            this.tableViewer = viewer;
            this.forType = forType;
        }

        protected CellEditor getCellEditor(Object o) {
            return new CheckboxCellEditor(null, 32);
        }

        protected boolean canEdit(Object o) {
            return true;
        }

        protected Object getValue(Object o) {
            Medicament medication = (Medicament)o;
            return this.forType.equals((Object)medication.entryType);
        }

        protected void setValue(Object element, Object value) {
            Medicament medication = (Medicament)element;
            medication.entryType = Boolean.TRUE.equals(value) ? this.forType : null;
            this.tableViewer.refresh();
        }
    }

    static abstract class EmulatedCheckBoxLabelProvider
    extends ColumnLabelProvider {
        private static Image CHECKED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.emediplan.ui", (String)"rsc/checked_checkbox.png").createImage();
        private static Image UNCHECKED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.emediplan.ui", (String)"rsc/unchecked_checkbox.png").createImage();

        EmulatedCheckBoxLabelProvider() {
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return this.isChecked(element) ? CHECKED : UNCHECKED;
        }

        protected abstract boolean isChecked(Object var1);
    }
}

