/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan;

import at.medevit.elexis.emediplan.core.EMediplanServiceHolder;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.ui.ImportEMediplanDialog;
import ch.elexis.barcode.scanner.BarcodeScannerMessage;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Startup
implements IStartup {
    private static Logger logger = LoggerFactory.getLogger(Startup.class);
    ElexisEventListener elexisEventListenerImpl;

    public void earlyStartup() {
        this.elexisEventListenerImpl = new ElexisEventListenerImpl(BarcodeScannerMessage.class, 4){

            public void run(ElexisEvent ev) {
                BarcodeScannerMessage b = (BarcodeScannerMessage)ev.getGenericObject();
                if (Startup.this.hasMediplanHeader(b.getChunk())) {
                    Startup.openEMediplanImportDialog(b.getChunk(), null);
                }
            }
        };
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.elexisEventListenerImpl});
    }

    public static void openEMediplanImportDialog(String chunk, final String selectedPatientId) {
        Patient patient;
        final Medication medication = EMediplanServiceHolder.getService().createModelFromChunk(chunk);
        if (selectedPatientId != null && medication.Patient != null) {
            medication.Patient.patientId = selectedPatientId;
        }
        EMediplanServiceHolder.getService().addExistingArticlesToMedication(medication);
        if (medication != null && medication.Patient != null && medication.Patient.patientId != null && (patient = Patient.load((String)medication.Patient.patientId)).exists()) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)patient);
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.core.ui.medication.views.MedicationView");
                    }
                    catch (PartInitException e) {
                        logger.warn("cannot open view with id: ch.elexis.core.ui.medication.views.MedicationView", (Throwable)e);
                    }
                    logger.debug("Opening ImportEMediplanDialog");
                    ImportEMediplanDialog dlg = new ImportEMediplanDialog(UiDesk.getTopShell(), medication, selectedPatientId == null);
                    dlg.open();
                }
            });
        }
    }

    private boolean hasMediplanHeader(String chunk) {
        return chunk.startsWith("CHMED");
    }

    public static String getDecodedJsonString(@NonNull String encodedJson) {
        String content = encodedJson.substring(9);
        byte[] zipped = Base64.getMimeDecoder().decode(content);
        StringBuilder sb = new StringBuilder();
        try {
            String read;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(zipped));
            InputStreamReader reader = new InputStreamReader(gzip);
            BufferedReader in = new BufferedReader(reader);
            while ((read = in.readLine()) != null) {
                sb.append(read);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Startup.class).error("Error decoding json", (Throwable)e);
            throw new IllegalStateException("Error decoding json", e);
        }
        return sb.toString();
    }
}

