/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.print;

import ch.elexis.core.types.Gender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;

public class ContactInfo {
    String title;
    String lastname;
    String firstname;
    String street1;
    String street2;
    String city;
    String zip;
    String email;
    String menumber;
    String birthdate;
    String gender;
    String tel;
    String insurancenumber;

    public static ContactInfo fromPatient(Patient pat) {
        ContactInfo ret = new ContactInfo();
        ret.setBirthdate(pat.getGeburtsdatum());
        ret.setCity(pat.get("Ort"));
        ret.setFirstname(pat.getVorname());
        ret.setGender(pat.getGender() == Gender.FEMALE ? "W" : "M");
        ret.setLastname(pat.getName());
        ret.setStreet1(pat.get("Strasse"));
        ret.setZip(pat.get("Plz"));
        ret.setTel(pat.get("Telefon1"));
        return ret;
    }

    public static ContactInfo fromKontakt(Kontakt kon) {
        ContactInfo ret = new ContactInfo();
        if (kon.istOrganisation()) {
            ret.setZip(kon.get("Plz"));
            ret.setCity(kon.get("Ort"));
            ret.setStreet1(kon.get("Strasse"));
            ret.setLastname(kon.get("Bezeichnung2"));
            ret.setFirstname(kon.get("Bezeichnung1"));
            ret.setTel(kon.get("Telefon1"));
        } else if (kon.istPerson()) {
            ret.setZip(kon.get("Plz"));
            ret.setCity(kon.get("Ort"));
            ret.setStreet1(kon.get("Strasse"));
            ret.setLastname(kon.get("Bezeichnung1"));
            ret.setFirstname(kon.get("Bezeichnung2"));
            ret.setBirthdate(kon.get("Geburtsdatum"));
            ret.setGender(kon.get("Geschlecht"));
            ret.setTel(kon.get("Telefon1"));
            ret.setTitle(kon.get("Titel"));
        } else {
            ret.setZip(kon.get("Plz"));
            ret.setCity(kon.get("Ort"));
            ret.setStreet1(kon.get("Strasse"));
            ret.setLastname(kon.get("Bezeichnung1"));
            ret.setFirstname(kon.get("Bezeichnung2"));
        }
        return ret;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMenumber() {
        return this.menumber;
    }

    public void setMenumber(String menumber) {
        this.menumber = menumber;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInsurancenumber() {
        return this.insurancenumber;
    }

    public void setInsurancenumber(String inumber) {
        this.insurancenumber = inumber;
    }

    public String toString() {
        return "ContactInfo: " + this.firstname + " " + this.lastname + " " + this.city + " " + this.zip + " " + this.menumber;
    }
}

