/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.chmed16a;

import at.medevit.elexis.emediplan.core.model.chmed16a.Posology;
import at.medevit.elexis.emediplan.core.model.chmed16a.PrivateField;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.data.Anwender;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;

public class Medicament {
    public String Id;
    public int IdType;
    public List<Posology> Pos;
    public String Unit;
    public String TkgRsn;
    public String AppInstr;
    public int AutoMed;
    public String PrscBy;
    public String Roa;
    public int Rep;
    public int Subs;
    public int NbPack;
    public List<PrivateField> PFields;
    public transient ArtikelstammItem artikelstammItem;
    public transient String dosis;
    public transient String dateFrom;
    public transient String dateTo;
    public transient State state = State.NEW;
    public transient Prescription foundPrescription;
    public transient String stateInfo = "";
    public transient EntryType entryType;
    public static final String FREETEXT_PREFIX = "[Dosis: ";
    public static final String FREETEXT_POSTFIX = "]";

    public static List<Medicament> fromPrescriptions(List<Prescription> prescriptions, boolean addDesc) {
        if (prescriptions != null && !prescriptions.isEmpty()) {
            ArrayList<Medicament> ret = new ArrayList<Medicament>();
            for (Prescription prescription : prescriptions) {
                String freeTextDosis;
                Medicament medicament = new Medicament();
                medicament.Unit = "";
                medicament.AutoMed = 0;
                medicament.AppInstr = prescription.getBemerkung();
                medicament.TkgRsn = prescription.getDisposalComment();
                Artikel article = prescription.getArtikel();
                medicament.IdType = Medicament.getIdType(article);
                medicament.Id = Medicament.getId(article);
                medicament.Pos = Posology.fromPrescription(prescription);
                if (addDesc) {
                    Medicament.addDsc(medicament, article);
                }
                Medicament.addTkgSch(medicament, prescription);
                if (medicament.Pos != null && !medicament.Pos.isEmpty() && (medicament.Pos.get((int)0).TT == null || medicament.Pos.get((int)0).TT.isEmpty()) && (freeTextDosis = Medicament.getDosageAsFreeText(prescription.getDosis())) != null) {
                    medicament.AppInstr = String.valueOf(medicament.AppInstr) + FREETEXT_PREFIX + freeTextDosis + FREETEXT_POSTFIX;
                }
                String prescriptorId = prescription.get("prescriptor");
                medicament.PrscBy = Medicament.getPrescriptorEAN(prescriptorId);
                ret.add(medicament);
            }
            return ret;
        }
        return null;
    }

    private static void addTkgSch(Medicament medicament, Prescription prescription) {
        if (medicament.PFields == null) {
            medicament.PFields = new ArrayList<PrivateField>();
        }
        PrivateField privateField = new PrivateField();
        privateField.Nm = "TkgSch";
        privateField.Val = prescription.getEntryType() == EntryType.SYMPTOMATIC_MEDICATION ? "Prd" : (prescription.getEntryType() == EntryType.RESERVE_MEDICATION ? "Ond" : "Cnt");
        medicament.PFields.add(privateField);
    }

    private static void addDsc(Medicament medicament, Artikel article) {
        if (medicament.PFields == null) {
            medicament.PFields = new ArrayList<PrivateField>();
        }
        PrivateField privateField = new PrivateField();
        privateField.Nm = "Dsc";
        privateField.Val = article.getText();
        medicament.PFields.add(privateField);
    }

    private static String getDosageAsFreeText(String dosis) {
        if (dosis != null && !dosis.isEmpty()) {
            boolean isFreetext;
            String[] signature = Prescription.getSignatureAsStringArray((String)dosis);
            boolean bl = isFreetext = !signature[0].isEmpty() && signature[1].isEmpty() && signature[2].isEmpty() && signature[3].isEmpty();
            if (isFreetext) {
                return signature[0];
            }
        }
        return null;
    }

    private static String getPrescriptorEAN(String prescriptorId) {
        String ean;
        Anwender prescriptor;
        if (prescriptorId != null && !prescriptorId.isEmpty() && (prescriptor = Anwender.load((String)prescriptorId)) != null && prescriptor.exists() && (ean = prescriptor.getXid("www.xid.ch/id/ean")) != null && !ean.isEmpty()) {
            return ean;
        }
        return null;
    }

    private static int getIdType(Artikel article) {
        String gtin = article.getEAN();
        if (gtin != null && !gtin.isEmpty() && gtin.startsWith("76")) {
            return 2;
        }
        String pharma = article.getPharmaCode();
        if (pharma == null || pharma.isEmpty()) {
            pharma = article.get("SubID");
        }
        if (pharma != null && !pharma.isEmpty() && !pharma.startsWith("**ERROR:")) {
            return 3;
        }
        return 1;
    }

    private static String getId(Artikel article) {
        String gtin = article.getEAN();
        if (gtin != null && !gtin.isEmpty() && gtin.startsWith("76")) {
            return gtin;
        }
        String pharma = article.getPharmaCode();
        if (pharma == null || pharma.isEmpty()) {
            pharma = article.get("SubID");
        }
        if (pharma != null && !pharma.isEmpty() && !pharma.startsWith("**ERROR:")) {
            return pharma;
        }
        if (Medicament.getIdType(article) == 1) {
            return article.getText();
        }
        throw new IllegalStateException("No ID (GTIN, Pharmacode) for article [" + article.getLabel() + FREETEXT_POSTFIX);
    }

    public boolean isMedicationExpired() {
        if (this.dateTo != null) {
            TimeTool now = new TimeTool();
            now.add(13, 5);
            if (new TimeTool(this.dateTo).isBefore(now)) {
                return true;
            }
        }
        return false;
    }

    public static enum State {
        NEW,
        ATC,
        ATC_SAME,
        ATC_SAME_DOSAGE,
        GTIN_SAME,
        GTIN_SAME_DOSAGE;


        public static boolean isHigherState(State current, State newState) {
            return current.ordinal() < newState.ordinal();
        }
    }
}

