/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.internal;

import at.medevit.elexis.emediplan.core.EMediplanService;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medicament;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.core.model.chmed16a.Posology;
import at.medevit.elexis.inbox.model.IInboxElementService;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.preferences.Messages;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class EMediplanServiceImpl
implements EMediplanService {
    private static Logger logger = LoggerFactory.getLogger(EMediplanServiceImpl.class);
    private IInboxElementService service;
    private Gson gson = new GsonBuilder().create();

    @Override
    public void exportEMediplanPdf(Mandant author, Patient patient, List<Prescription> prescriptions, boolean addDesc, OutputStream output) {
        if (prescriptions != null && !prescriptions.isEmpty() && output != null) {
            Optional<String> jsonString = this.getJsonString(author, patient, prescriptions, addDesc);
            Optional qrCode = jsonString.map(json -> this.getQrCode((String)json)).orElse(Optional.empty());
            Optional<at.medevit.elexis.emediplan.core.model.print.Medication> jaxbModel = this.getJaxbModel(author, patient, prescriptions);
            jaxbModel.ifPresent(model -> this.createPdf(qrCode, model, output));
        }
    }

    @Override
    public void exportEMediplanJson(Mandant author, Patient patient, List<Prescription> prescriptions, OutputStream output) {
        Optional<String> jsonString;
        if (prescriptions != null && !prescriptions.isEmpty() && output != null && (jsonString = this.getJsonString(author, patient, prescriptions, false)).isPresent()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (PrintWriter writer = new PrintWriter(output);){
                writer.write(jsonString.get());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void createPdf(Optional<Image> qrCode, Object jaxbModel, OutputStream output) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference fopFactoryRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
        if (fopFactoryRef == null) {
            throw new IllegalStateException("No IFormattedOutputFactory available");
        }
        IFormattedOutputFactory fopFactory = (IFormattedOutputFactory)bundleContext.getService(fopFactoryRef);
        IFormattedOutput foOutput = fopFactory.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.JAXB, IFormattedOutputFactory.OutputType.PDF);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("logoJpeg", this.getEncodedLogo());
        parameters.put("commentText", CoreHub.userCfg.get("medication/settings/emediplanHeaderComment", Messages.Medication_headerComment));
        qrCode.ifPresent(qr -> parameters.put("qrJpeg", this.getEncodedQr((Image)qr)));
        foOutput.transform(jaxbModel, EMediplanServiceImpl.class.getResourceAsStream("/rsc/xslt/emediplan.xslt"), output, parameters);
        bundleContext.ungetService(fopFactoryRef);
    }

    private String getEncodedQr(Image qr) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{qr.getImageData()};
                imageLoader.compression = 100;
                imageLoader.save((OutputStream)output, 4);
                return "data:image/jpg;base64," + Base64.getEncoder().encodeToString(output.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error encoding QR", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEncodedLogo() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                InputStream input = this.getClass().getResourceAsStream("/rsc/img/Logo_Full.jpeg");
                try {
                    String string;
                    block16: {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        try {
                            IOUtils.copy((InputStream)input, (OutputStream)output);
                            string = "data:image/jpg;base64," + Base64.getEncoder().encodeToString(output.toByteArray());
                            return string;
                        }
                        finally {
                            if (output == null) break block16;
                            output.close();
                        }
                    }
                    if (input != null) {
                        input.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error encoding logo", (Throwable)e);
            return "";
        }
    }

    protected Optional<Image> getQrCode(@NonNull String json) {
        String encodedJson = this.getEncodedJson(json);
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode(encodedJson, BarcodeFormat.QR_CODE, 470, 470, hintMap);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            ImageData data = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    data.setPixel(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
                    ++x;
                }
                ++y;
            }
            return Optional.of(new Image((Device)Display.getDefault(), data));
        }
        catch (WriterException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating QR", (Throwable)e);
            return Optional.empty();
        }
    }

    protected String getEncodedJson(@NonNull String json) {
        StringBuilder sb = new StringBuilder();
        sb.append("CHMED16A1");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(json.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error encoding json", (Throwable)e);
            throw new IllegalStateException("Error encoding json", e);
        }
        sb.append(Base64.getEncoder().encodeToString(out.toByteArray()));
        return sb.toString();
    }

    protected String getDecodedJsonString(@NonNull String encodedJson) {
        String content = encodedJson.substring(9);
        byte[] zipped = Base64.getMimeDecoder().decode(content);
        StringBuilder sb = new StringBuilder();
        try {
            String read;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(zipped));
            InputStreamReader reader = new InputStreamReader(gzip);
            BufferedReader in = new BufferedReader(reader);
            while ((read = in.readLine()) != null) {
                sb.append(read);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error decoding json", (Throwable)e);
            throw new IllegalStateException("Error decoding json", e);
        }
        return sb.toString();
    }

    protected Optional<at.medevit.elexis.emediplan.core.model.print.Medication> getJaxbModel(Mandant author, Patient patient, List<Prescription> prescriptions) {
        at.medevit.elexis.emediplan.core.model.print.Medication medication = at.medevit.elexis.emediplan.core.model.print.Medication.fromPrescriptions(author, patient, prescriptions);
        return Optional.ofNullable(medication);
    }

    protected Optional<String> getJsonString(Mandant author, Patient patient, List<Prescription> prescriptions, boolean addDesc) {
        Medication medication = Medication.fromPrescriptions(author, patient, prescriptions, addDesc);
        return Optional.ofNullable(this.gson.toJson((Object)medication));
    }

    @Override
    public Medication createModelFromChunk(String chunk) {
        String json = this.getDecodedJsonString(chunk);
        if (chunk.length() > 8) {
            logger.debug("json version: " + chunk.substring(5, 8));
            Medication ret = this.createModelFromJsonString(json);
            ret.chunk = chunk;
            return ret;
        }
        logger.error("invalid json length - cannot parseable");
        return null;
    }

    protected Medication createModelFromJsonString(String jsonString) {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(Medication.class, (Object)new MedicationDeserializer());
        Gson g = gb.create();
        Medication m = (Medication)g.fromJson(jsonString, Medication.class);
        return m;
    }

    @Override
    public void addExistingArticlesToMedication(Medication medication) {
        if (medication != null) {
            this.findPatientForMedication(medication);
            ArrayList<Medicament> medicaments = new ArrayList<Medicament>();
            if (medication.Medicaments != null) {
                Iterator<Medicament> iterator = medication.Medicaments.iterator();
                while (iterator.hasNext()) {
                    Medicament in;
                    Medicament toAdd = in = iterator.next();
                    if (in.Pos == null) continue;
                    if (in.Pos.size() > 1) {
                        ArrayList<Posology> posologies = new ArrayList<Posology>(in.Pos);
                        for (Posology p : posologies) {
                            try {
                                Gson gson = new Gson();
                                String json = gson.toJson((Object)in);
                                toAdd = (Medicament)gson.fromJson(json, Medicament.class);
                                toAdd.Pos = new ArrayList<Posology>();
                                toAdd.Pos.add(p);
                            }
                            catch (Exception e) {
                                logger.warn("cannot clone medicament id: " + toAdd.Id, (Throwable)e);
                            }
                            this.addMedicamentToMedication(medication, medicaments, toAdd);
                        }
                        continue;
                    }
                    this.addMedicamentToMedication(medication, medicaments, toAdd);
                }
                medication.Medicaments = medicaments;
            }
        }
    }

    private void findPatientForMedication(Medication medication) {
        if (medication.Patient != null) {
            Patient patient = null;
            if (medication.Patient.patientId != null) {
                patient = Patient.load((String)medication.Patient.patientId);
            }
            if (patient == null) {
                String bDate = medication.Patient.BDt;
                patient = KontaktMatcher.findPatient((String)medication.Patient.LName, (String)medication.Patient.FName, (String)(bDate != null ? bDate.replace("-", "") : null), null, null, null, null, null, (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.ASK);
            }
            if (patient != null && patient.getId() != null && patient.exists()) {
                medication.Patient.patientId = patient.getId();
                medication.Patient.patientLabel = patient.getPersonalia();
            }
        }
    }

    private void addMedicamentToMedication(Medication medication, List<Medicament> medicaments, Medicament toAdd) {
        if (toAdd.Pos != null && !toAdd.Pos.isEmpty()) {
            Posology pos = toAdd.Pos.get(0);
            StringBuffer buf = new StringBuffer();
            if (pos.D != null) {
                int size = pos.D.size();
                for (float f : pos.D) {
                    if (f % 1.0f != 0.0f) {
                        buf.append(f);
                    } else {
                        buf.append((int)f);
                    }
                    if (--size == 0) continue;
                    buf.append("-");
                }
            }
            toAdd.dosis = buf.toString();
            this.transformAppInstrToFreeTextDosage(toAdd);
            toAdd.dateFrom = pos.DtFrom;
            toAdd.dateTo = pos.DtTo;
        }
        this.findArticleForMedicament(toAdd);
        this.setPresciptionsToMedicament(medication, toAdd);
        medicaments.add(toAdd);
    }

    private void transformAppInstrToFreeTextDosage(Medicament toAdd) {
        String[] split;
        if (toAdd.dosis.isEmpty() && toAdd.AppInstr != null && (split = toAdd.AppInstr.split("\\[Dosis: ")).length > 1) {
            toAdd.AppInstr = split[0];
            int idx = split[1].lastIndexOf("]");
            if (idx > 0) {
                toAdd.dosis = split[1].substring(0, idx);
            }
        }
    }

    @Override
    public void setPresciptionsToMedicament(Medication medication, Medicament medicament) {
        if (medication.Patient != null && medication.Patient.patientId != null) {
            if (medicament.artikelstammItem != null) {
                Query qre = new Query(Prescription.class);
                qre.add("PatientID", "LIKE", medication.Patient.patientId);
                qre.orderBy(true, new String[]{"lastupdate"});
                List execute = qre.execute();
                TimeTool now = new TimeTool();
                now.add(13, 5);
                List<Prescription> patientPrescriptions = execute.parallelStream().filter(p -> !p.isStopped(now)).collect(Collectors.toList());
                this.setMedicamentState(medicament, patientPrescriptions);
            }
            this.setMedicamentStateInfo(medicament);
        }
    }

    private void setMedicamentState(Medicament medicament, List<Prescription> patientPrescriptions) {
        medicament.state = Medicament.State.NEW;
        medicament.foundPrescription = null;
        for (Prescription prescription : patientPrescriptions) {
            Artikel artikel = prescription.getArtikel();
            if (this.checkATCEquality(medicament.artikelstammItem.getATCCode(), artikel.getATC_code())) {
                if (Medicament.State.isHigherState(medicament.state, Medicament.State.ATC)) {
                    medicament.state = Medicament.State.ATC;
                    medicament.foundPrescription = prescription;
                }
                if (medicament.artikelstammItem.getATCCode().equals(artikel.getATC_code()) && Medicament.State.isHigherState(medicament.state, Medicament.State.ATC_SAME)) {
                    medicament.state = Medicament.State.ATC_SAME;
                    medicament.foundPrescription = prescription;
                    if (prescription.getDosis().equals(medicament.dosis) && Medicament.State.isHigherState(medicament.state, Medicament.State.ATC_SAME_DOSAGE)) {
                        medicament.state = Medicament.State.ATC_SAME_DOSAGE;
                        medicament.foundPrescription = prescription;
                    }
                }
            }
            if (!medicament.artikelstammItem.getGTIN().equals(artikel.getGTIN())) continue;
            if (Medicament.State.isHigherState(medicament.state, Medicament.State.GTIN_SAME)) {
                medicament.state = Medicament.State.GTIN_SAME;
                medicament.foundPrescription = prescription;
            }
            if (!prescription.getDosis().equals(medicament.dosis) || !Medicament.State.isHigherState(medicament.state, Medicament.State.GTIN_SAME_DOSAGE)) continue;
            medicament.state = Medicament.State.GTIN_SAME_DOSAGE;
            medicament.foundPrescription = prescription;
            break;
        }
    }

    private void setMedicamentStateInfo(Medicament medicament) {
        StringBuffer buf = new StringBuffer();
        if (medicament.artikelstammItem == null) {
            buf.append("Der Artikel wurde nicht gefunden.");
        } else if (medicament.isMedicationExpired()) {
            buf.append("Diese Medikation ist bereits am " + medicament.dateTo + " abgelaufen.");
        } else {
            if (Medicament.State.GTIN_SAME_DOSAGE.equals((Object)medicament.state) || Medicament.State.GTIN_SAME.equals((Object)medicament.state)) {
                buf.append("Dieses Medikament existiert bereits in Elexis.");
            } else if (Medicament.State.ATC_SAME_DOSAGE.equals((Object)medicament.state) || Medicament.State.ATC.equals((Object)medicament.state) || Medicament.State.ATC_SAME.equals((Object)medicament.state)) {
                buf.append(Medicament.State.ATC.equals((Object)medicament.state) ? "Medikament aus gleicher Wirkstoffgruppe bereits vorhanden." : "Medikament mit gleichem Wirkstoff bereits vorhanden.");
                if (medicament.foundPrescription != null && medicament.foundPrescription.getArtikel() != null) {
                    buf.append("\n(" + medicament.foundPrescription.getArtikel().getName() + ")");
                }
            } else if (Medicament.State.NEW.equals((Object)medicament.state)) {
                buf.append("Neues Medikament");
            }
            if (Medicament.State.ATC_SAME.equals((Object)medicament.state) || Medicament.State.GTIN_SAME.equals((Object)medicament.state)) {
                buf.append("\n\u00c4nderung bei der Dosierung.");
            }
        }
        medicament.stateInfo = buf.toString();
    }

    private boolean checkATCEquality(String atc1, String atc2) {
        if (atc1 != null && atc1.length() > 3 && atc2 != null) {
            return atc2.startsWith(atc1.substring(0, 4));
        }
        return atc1 != null && atc1.equals(atc2);
    }

    private void findArticleForMedicament(Medicament medicament) {
        ArtikelstammItem artikelstammItem;
        if (medicament.IdType == 2) {
            ArtikelstammItem artikelstammItem2 = ArtikelstammItem.findByEANorGTIN((String)medicament.Id);
            if (artikelstammItem2 != null) {
                medicament.artikelstammItem = artikelstammItem2;
            }
        } else if (medicament.IdType == 3 && (artikelstammItem = ArtikelstammItem.findByPharmaCode((String)medicament.Id)) != null) {
            medicament.artikelstammItem = artikelstammItem;
        }
    }

    @Override
    public boolean createInboxEntry(Medication medication, Mandant mandant) {
        if (this.service == null) {
            throw new IllegalStateException("No IInboxElementService for inbox defined");
        }
        if (medication != null) {
            if (medication.chunk != null && medication.Patient != null && medication.Patient.patientId != null) {
                Patient patient = Patient.load((String)medication.Patient.patientId);
                NamedBlob namedBlob = NamedBlob.load((String)medication.getNamedBlobId());
                namedBlob.putString(medication.chunk);
                if (namedBlob != null && patient.exists()) {
                    this.service.createInboxElement(patient, (Kontakt)mandant, (PersistentObject)namedBlob);
                    return true;
                }
            }
            StringBuffer buf = new StringBuffer("cannot add medication to list:");
            buf.append("[");
            buf.append("med chunk:" + medication.chunk);
            buf.append("med patient id:" + (medication.Patient != null ? medication.Patient.patientId : "null"));
            buf.append("]");
            logger.warn(buf.toString());
        } else {
            logger.error("cannot add medication to list: medication is null");
        }
        return false;
    }

    @Reference(unbind="-")
    public void setService(IInboxElementService service) {
        this.service = service;
    }

    public class MedicationDeserializer
    implements JsonDeserializer<Medication> {
        Gson g = new GsonBuilder().create();

        public Medication deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            Medication u = null;
            try {
                try {
                    u = (Medication)this.g.fromJson(json, Medication.class);
                    return u;
                }
                catch (JsonSyntaxException e) {
                    if (json.getAsJsonObject().get("Patient") != null) {
                        json.getAsJsonObject().get("Patient").getAsJsonObject().remove("Med");
                    }
                    u = (Medication)this.g.fromJson(json, Medication.class);
                    logger.warn("json parsed successfully - by removing the 'Med' attribute");
                }
            }
            catch (Exception e) {
                logger.error("unexpected json error", (Throwable)e);
            }
            return u;
        }
    }
}

