/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.vacdoc.service.internal;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.core.EhcCoreService;
import at.medevit.elexis.ehc.vacdoc.service.VacdocService;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.data.Artikel;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.ehealth_connector.cda.Consumable;
import org.ehealth_connector.cda.ch.utils.CdaChLoader;
import org.ehealth_connector.cda.ch.vacd.CdaChVacd;
import org.ehealth_connector.cda.ch.vacd.Immunization;
import org.ehealth_connector.common.Author;
import org.ehealth_connector.common.Code;
import org.ehealth_connector.common.Identificator;
import org.ehealth_connector.common.enums.CodeSystems;
import org.ehealth_connector.common.enums.LanguageCode;
import org.ehealth_connector.common.utils.DateUtil;
import org.ehealth_connector.valueset.enums.IdentityDomain;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.ch.CdaChVacdV1;
import org.openhealthtools.mdht.uml.cda.ch.ChPackage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class VacdocServiceImpl
implements VacdocService {
    private static Logger logger = LoggerFactory.getLogger(VacdocServiceImpl.class);
    private EhcCoreService ehcCoreService;

    public VacdocServiceImpl() {
        EClass vacdClass = ChPackage.eINSTANCE.getCdaChVacdV1();
        if (vacdClass == null) {
            logger.warn("Could not load VACD class from ch package");
        }
    }

    @Reference
    public void setEhcCoreService(EhcCoreService ehcCoreService) {
        this.ehcCoreService = ehcCoreService;
    }

    public void unsetEhcCoreService(EhcCoreService ehcCoreService) {
        this.ehcCoreService = null;
    }

    @Override
    public InputStream getXdmAsStream(CdaChVacd document) throws Exception {
        return this.ehcCoreService.getXdmAsStream((ClinicalDocument)document.getDoc());
    }

    @Override
    public CdaChVacd getVacdocDocument(Patient patient, Mandant mandant) {
        CdaChVacd doc = new CdaChVacd(LanguageCode.GERMAN, null, null);
        doc.setPatient(EhcCoreMapper.getEhcPatient((Patient)patient));
        doc.setCustodian(EhcCoreMapper.getEhcOrganization((Mandant)mandant));
        doc.addAuthor(EhcCoreMapper.getEhcAuthor((Mandant)mandant));
        doc.setLegalAuthenticator(EhcCoreMapper.getEhcAuthor((Mandant)mandant));
        return doc;
    }

    @Override
    public void addAllVaccinations(CdaChVacd doc) {
        org.ehealth_connector.common.Patient ehcPatient = doc.getPatient();
        Patient elexisPatient = EhcCoreMapper.getElexisPatient((org.ehealth_connector.common.Patient)ehcPatient);
        Query query = new Query(Vaccination.class);
        query.add("Patient_ID", "=", elexisPatient.getId());
        List vaccinations = query.execute();
        this.addVaccinations(doc, vaccinations);
    }

    @Override
    public void addVaccinations(CdaChVacd doc, List<Vaccination> vaccinations) {
        if (!vaccinations.isEmpty()) {
            for (Vaccination vaccination : vaccinations) {
                String identifier;
                Consumable consumable = new Consumable(vaccination.getShortBusinessName());
                consumable.setLotNr(vaccination.getLotNo());
                String code = vaccination.getAtcCode();
                if (code != null && !code.isEmpty()) {
                    Code atc = new Code((IdentityDomain)CodeSystems.WHOATCCode, code);
                    consumable.setWhoAtcCode(atc);
                }
                if ((identifier = vaccination.get("ean")) != null && !identifier.isEmpty()) {
                    Identificator ean = new Identificator((IdentityDomain)CodeSystems.GTIN, identifier);
                    consumable.setManufacturedProductId(ean);
                }
                Author author = null;
                if (this.isVaccinationMandantKnown(vaccination)) {
                    author = EhcCoreMapper.getEhcAuthor((Mandant)this.getVaccinationMandant(vaccination));
                } else {
                    String administratorName = this.getVaccinationAdministrator(vaccination);
                    author = new Author(EhcCoreMapper.getEhcName((String)administratorName));
                }
                Immunization immunization = new Immunization(consumable, author, DateUtil.date((String)vaccination.getDateOfAdministrationLabel()), null, null);
                doc.addImmunization(immunization);
            }
        }
    }

    private boolean isVaccinationMandantKnown(Vaccination vaccination) {
        Mandant mandant;
        String value = vaccination.get("administrator");
        return value.startsWith(Mandant.class.getName()) && (mandant = (Mandant)new PersistentObjectFactory().createFromString(value)) != null && mandant.exists();
    }

    private Mandant getVaccinationMandant(Vaccination vaccination) {
        Mandant mandant;
        String value = vaccination.get("administrator");
        if (value.startsWith(Mandant.class.getName()) && (mandant = (Mandant)new PersistentObjectFactory().createFromString(value)) != null && mandant.exists()) {
            return mandant;
        }
        return null;
    }

    private String getVaccinationAdministrator(Vaccination vaccination) {
        return vaccination.get("administrator");
    }

    @Override
    public Optional<CdaChVacd> loadVacdocDocument(InputStream document) throws Exception {
        try {
            CdaChLoader loader = new CdaChLoader();
            return Optional.of((CdaChVacd)loader.loadFromStream(document, CdaChVacd.class, CdaChVacdV1.class));
        }
        catch (Exception e) {
            logger.error("problem loading xml document", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void importImmunizations(Patient elexisPatient, List<Immunization> immunizations) {
        for (Immunization immunization : immunizations) {
            Consumable consumable = immunization.getConsumable();
            Code atcCode = consumable.getWhoAtcCode();
            Identificator gtin = consumable.getManufacturedProductId();
            Artikel article = this.resolveArticle(gtin, atcCode);
            Author author = immunization.getAuthor();
            if (article != null) {
                new Vaccination(elexisPatient.getId(), article, immunization.getApplyDate(), consumable.getLotNr(), author != null ? author.getCompleteName() : "");
                continue;
            }
            logger.warn("Article [" + consumable.getTradeName() + "] not found GTIN [" + (gtin != null ? gtin.getExtension() : "") + "]");
            new Vaccination(elexisPatient.getId(), "", consumable.getTradeName(), gtin != null ? gtin.getExtension() : "", atcCode != null ? atcCode.getCode() : "", immunization.getApplyDate(), consumable.getLotNr(), author != null ? author.getCompleteName() : "");
        }
    }

    private Artikel resolveArticle(Identificator gtin, Code atcCode) {
        String atcStr;
        String gtinStr = gtin != null ? gtin.getExtension() : null;
        String string = atcStr = atcCode != null ? atcCode.getCode() : null;
        if (gtinStr != null) {
            Query query = new Query(ArtikelstammItem.class);
            query.add("GTIN", "=", gtinStr);
            List articles = query.execute();
            if (articles != null && !articles.isEmpty()) {
                return (Artikel)articles.get(0);
            }
        } else if (atcStr != null && !atcStr.isEmpty()) {
            Query query = new Query(ArtikelstammItem.class);
            query.add("ATC", "=", atcStr);
            List articles = query.execute();
            if (articles != null && !articles.isEmpty()) {
                String displayName;
                String string2 = displayName = atcCode != null ? atcCode.getDisplayName().toLowerCase() : null;
                if (displayName != null && !displayName.isEmpty()) {
                    for (ArtikelstammItem artikelstammItem : articles) {
                        if (!artikelstammItem.getName().toLowerCase().contains(displayName)) continue;
                        return artikelstammItem;
                    }
                }
                return (Artikel)articles.get(0);
            }
        }
        return null;
    }
}

