/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.vacdoc.service.internal;

import at.medevit.elexis.ehc.vacdoc.service.MeineImpfungenService;
import at.medevit.elexis.ehc.vacdoc.service.VacdocService;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.services.ISSLStoreService;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ehealth_connector.cda.ch.vacd.CdaChVacd;
import org.ehealth_connector.common.Identificator;
import org.ehealth_connector.common.Name;
import org.ehealth_connector.common.ch.enums.ConfidentialityCode;
import org.ehealth_connector.common.enums.CodeSystems;
import org.ehealth_connector.common.enums.LanguageCode;
import org.ehealth_connector.common.utils.DateUtil;
import org.ehealth_connector.communication.AffinityDomain;
import org.ehealth_connector.communication.AtnaConfig;
import org.ehealth_connector.communication.ConvenienceMasterPatientIndexV3;
import org.ehealth_connector.communication.Destination;
import org.ehealth_connector.communication.DocumentRequest;
import org.ehealth_connector.communication.MasterPatientIndexQuery;
import org.ehealth_connector.communication.MasterPatientIndexQueryResponse;
import org.ehealth_connector.communication.ch.ConvenienceCommunicationCh;
import org.ehealth_connector.communication.ch.DocumentMetadataCh;
import org.ehealth_connector.communication.ch.enums.AvailabilityStatus;
import org.ehealth_connector.communication.ch.enums.ClassCode;
import org.ehealth_connector.communication.ch.enums.FormatCode;
import org.ehealth_connector.communication.ch.enums.HealthcareFacilityTypeCode;
import org.ehealth_connector.communication.ch.enums.MimeType;
import org.ehealth_connector.communication.ch.enums.TypeCode;
import org.ehealth_connector.communication.ch.xd.storedquery.FindDocumentsQuery;
import org.ehealth_connector.communication.xd.storedquery.StoredQueryInterface;
import org.openhealthtools.ihe.atna.auditor.XDSSourceAuditor;
import org.openhealthtools.ihe.atna.auditor.context.AuditorModuleConfig;
import org.openhealthtools.ihe.atna.auditor.context.AuditorModuleContext;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomainException;
import org.openhealthtools.ihe.xds.document.DocumentDescriptor;
import org.openhealthtools.ihe.xds.document.XDSDocument;
import org.openhealthtools.ihe.xds.metadata.AvailabilityStatusType;
import org.openhealthtools.ihe.xds.metadata.DocumentEntryType;
import org.openhealthtools.ihe.xds.response.DocumentEntryResponseType;
import org.openhealthtools.ihe.xds.response.XDSQueryResponseType;
import org.openhealthtools.ihe.xds.response.XDSResponseType;
import org.openhealthtools.ihe.xds.response.XDSRetrieveResponseType;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MeineImpfungenServiceImpl
implements MeineImpfungenService {
    public static final String ORGANIZATIONAL_ID = "2.16.756.5.30.1.139.1.1.3.9999";
    private static final String TEST_PDQ_REQUEST_URL = "https://test.suisse-open-exchange.healthcare/services/mpi/services/PDQSupplier_Port_Soap12";
    private static final String TEST_XDS_REGISTRY_URL = "https://test.suisse-open-exchange.healthcare/services/registry/services/DocumentRegistry";
    private static final String TEST_XDS_REPOSITORY_URL = "https://test.meineimpfungen.ch/ihe/xds/DocumentRepository";
    private static final String TEST_ATNA_URL = "tls://test.suisse-open-exchange.healthcare:5544";
    private static final String PRODUCTIV_PDQ_REQUEST_URL = "https://suisse-open-exchange.healthcare/services/mpi/services/PDQSupplier_Port_Soap12";
    private static final String PRODUCTIV_XDS_REGISTRY_URL = "https://suisse-open-exchange.healthcare/services/registry/services/DocumentRegistry";
    private static final String PRODUCTIV_XDS_REPOSITORY_URL = "https://meineimpfungen.ch/ihe/xds/DocumentRepository";
    private static final String PRODUCTIV_ATNA_URL = "tls://suisse-open-exchange.healthcare:5544";
    private AffinityDomain affinityDomain;
    private static final Logger logger = LoggerFactory.getLogger(MeineImpfungenServiceImpl.class);
    private VacdocService vacdocService;
    private ISSLStoreService sslStoreService;
    private ElexisEventListener mandantListener;
    private Optional<KeyStore> currentTrustStore = Optional.empty();
    private Optional<KeyStore> currentKeyStore = Optional.empty();

    @Reference
    public void setVacdocService(VacdocService vacdocService) {
        this.vacdocService = vacdocService;
    }

    public void unsetVacdocService(VacdocService vacdocService) {
        this.vacdocService = null;
    }

    @Reference
    public void setSSLService(ISSLStoreService sslStoreService) {
        this.sslStoreService = sslStoreService;
    }

    public void unsetSSLService(ISSLStoreService sslStoreService) {
        this.sslStoreService = null;
    }

    @Activate
    public void activate() {
        this.updateConfiguration();
        if (this.mandantListener == null) {
            this.mandantListener = new MandantChangedListener();
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.mandantListener});
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.mandantListener != null) {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.mandantListener});
            this.mandantListener = null;
        }
    }

    private void updateAffinityDomain() throws URISyntaxException, SecurityDomainException {
        this.affinityDomain = this.getMeineImpfungenAffinityDomain();
        AuditorModuleContext ctx = AuditorModuleContext.getContext();
        AuditorModuleConfig auditorConfig = ctx.getAuditor(XDSSourceAuditor.class).getConfig();
        try {
            auditorConfig.setAuditRepositoryUri(this.affinityDomain.getAtnaConfig().getAuditRepositoryUri());
        }
        catch (Exception e) {
            logger.error("Audit configuration problem", (Throwable)e);
        }
    }

    private AffinityDomain getMeineImpfungenAffinityDomain() throws URISyntaxException {
        Destination pdqDestination = new Destination(ORGANIZATIONAL_ID, new URI(this.getPdqUrl()));
        pdqDestination.setSenderApplicationOid(ORGANIZATIONAL_ID);
        pdqDestination.setReceiverApplicationOid("2.16.756.5.30.1.147.1.1");
        pdqDestination.setReceiverFacilityOid("2.16.756.5.30.1.147.1.1");
        Destination xdsRegistryDestination = new Destination(ORGANIZATIONAL_ID, new URI(this.getXdsRegistryUrl()));
        Destination xdsRepositoryDestination = new Destination(ORGANIZATIONAL_ID, new URI(this.getXdsRepositoryUrl()));
        xdsRegistryDestination.setReceiverApplicationOid("2.16.756.5.30.1.147.2.3.2");
        xdsRegistryDestination.setReceiverFacilityOid("2.16.756.5.30.1.147.2.3.2");
        AffinityDomain ret = new AffinityDomain();
        ret.setPdqDestination(pdqDestination);
        ret.setRegistryDestination(xdsRegistryDestination);
        ret.addRepository(xdsRepositoryDestination);
        ret.setPixDestination(pdqDestination);
        AtnaConfig atnaConfig = new AtnaConfig();
        atnaConfig.setAuditRepositoryUri(this.getAtnaUrl());
        atnaConfig.setAuditSourceId("EHC-Elexis");
        ret.setAtnaConfig(atnaConfig);
        return ret;
    }

    private String getAtnaUrl() {
        if ("productiv".equals(CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test"))) {
            return PRODUCTIV_ATNA_URL;
        }
        return TEST_ATNA_URL;
    }

    private String getXdsRepositoryUrl() {
        if ("productiv".equals(CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test"))) {
            return PRODUCTIV_XDS_REPOSITORY_URL;
        }
        return TEST_XDS_REPOSITORY_URL;
    }

    private String getXdsRegistryUrl() {
        if ("productiv".equals(CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test"))) {
            return PRODUCTIV_XDS_REGISTRY_URL;
        }
        return TEST_XDS_REGISTRY_URL;
    }

    private String getPdqUrl() {
        if ("productiv".equals(CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test"))) {
            return PRODUCTIV_PDQ_REQUEST_URL;
        }
        return TEST_PDQ_REQUEST_URL;
    }

    @Override
    public synchronized boolean updateConfiguration() {
        this.affinityDomain = null;
        String endpoint = CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test");
        String keystorePath = CoreHub.mandantCfg.get("meineimpfungen.keystorePath", null);
        String keystorePass = CoreHub.mandantCfg.get("meineimpfungen.keystorePass", null);
        if (keystorePass != null && keystorePath != null) {
            try {
                if (!this.currentTrustStore.isPresent()) {
                    this.currentTrustStore = this.sslStoreService.loadKeyStore(this.getKeyStore(endpoint), "trustit", "JKS");
                    this.currentTrustStore.ifPresent(store -> this.sslStoreService.addTrustStore(store));
                }
                this.currentKeyStore.ifPresent(store -> this.sslStoreService.removeKeyStore(store));
                this.currentKeyStore = this.sslStoreService.loadKeyStore(keystorePath, keystorePass, "PKCS12");
                this.currentKeyStore.ifPresent(store -> this.sslStoreService.addKeyStore(store, keystorePass));
                this.updateAffinityDomain();
            }
            catch (URISyntaxException | SecurityDomainException e) {
                logger.error("Could not update affinity domain.", e);
                return false;
            }
        } else {
            this.currentKeyStore.ifPresent(store -> this.sslStoreService.removeKeyStore(store));
            this.currentKeyStore = Optional.empty();
        }
        return true;
    }

    private InputStream getKeyStore(String endpoint) {
        if ("productiv".equals(endpoint)) {
            return this.getClass().getResourceAsStream("/rsc/myvaccines-truststore.jks");
        }
        return this.getClass().getResourceAsStream("/rsc/myvtest-truststore.jks");
    }

    @Override
    public boolean isVaild() {
        return this.affinityDomain != null && this.affinityDomain.getPdqDestination() != null;
    }

    @Override
    public List<CdaChVacd> getDocuments(org.ehealth_connector.common.Patient ehcPatient) {
        ArrayList<CdaChVacd> ret = new ArrayList<CdaChVacd>();
        List<DocumentEntryType> entryTypes = this.getAllPatientDocumentEntryTypes(ehcPatient);
        try {
            for (DocumentEntryType documentEntryType : entryTypes) {
                InputStream documentStream;
                if (documentEntryType.getAvailabilityStatus() == null || documentEntryType.getAvailabilityStatus() != AvailabilityStatusType.APPROVED_LITERAL || !"text/xml".equals(documentEntryType.getMimeType()) || (documentStream = this.getDocumentAsInputStream(documentEntryType)) == null) continue;
                Optional<CdaChVacd> vacdocOpt = this.vacdocService.loadVacdocDocument(documentStream);
                vacdocOpt.ifPresent(d -> {
                    boolean bl = ret.add((CdaChVacd)d);
                });
            }
        }
        catch (Exception e) {
            logger.error("Could not load CdaChVacd", (Throwable)e);
            e.printStackTrace(System.err);
        }
        return ret;
    }

    private List<DocumentEntryType> getAllPatientDocumentEntryTypes(org.ehealth_connector.common.Patient ehcPatient) {
        ArrayList<DocumentEntryType> ret = new ArrayList<DocumentEntryType>();
        List ids = ehcPatient.getIds();
        if (ids != null && !ids.isEmpty()) {
            FindDocumentsQuery fdq = new FindDocumentsQuery((Identificator)ids.get(0), null, null, null, null, null, null, null, AvailabilityStatus.APPROVED);
            logger.debug("getDocumentEntryTypes");
            ConvenienceCommunicationCh convComm = new ConvenienceCommunicationCh(this.affinityDomain);
            logger.debug("queryDocuments");
            XDSQueryResponseType regDocQuery = convComm.queryDocuments((StoredQueryInterface)fdq);
            if (regDocQuery != null) {
                List docEntrieResponses = regDocQuery.getDocumentEntryResponses();
                logger.info("Document Entries found: " + docEntrieResponses.size());
                for (DocumentEntryResponseType docEntryResponse : docEntrieResponses) {
                    DocumentEntryType docEntry = docEntryResponse.getDocumentEntry();
                    ret.add(docEntry);
                }
            }
            convComm.clearDocuments();
        }
        return ret;
    }

    private String getDocumentAsString(DocumentEntryType docEntry) throws IOException {
        InputStream inputStream = this.getDocumentAsInputStream(docEntry);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            return buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private InputStream getDocumentAsInputStream(DocumentEntryType docEntry) {
        DocumentRequest documentRequest = new DocumentRequest(docEntry.getRepositoryUniqueId(), this.affinityDomain.getRepositoryDestination().getUri(), docEntry.getEntryUUID());
        ConvenienceCommunicationCh convComm = new ConvenienceCommunicationCh(this.affinityDomain);
        XDSRetrieveResponseType rrt = convComm.retrieveDocument(documentRequest);
        try {
            if (rrt.getErrorList() != null) {
                logger.error("error retriveing doc " + docEntry.getEntryUUID() + " - " + rrt.getErrorList().getHighestSeverity().getName());
            }
            if (rrt.getAttachments() == null || rrt.getAttachments().size() != 1) {
                logger.error("document not downloaded or more than one");
                return null;
            }
            InputStream inputStream = ((XDSDocument)rrt.getAttachments().get(0)).getStream();
            return inputStream;
        }
        finally {
            convComm.clearDocuments();
        }
    }

    @Override
    public List<org.ehealth_connector.common.Patient> getPatients(Patient elexisPatient) {
        MasterPatientIndexQueryResponse ret;
        MasterPatientIndexQuery mpiQuery = new MasterPatientIndexQuery(this.affinityDomain.getPdqDestination());
        mpiQuery.addDomainToReturn("2.16.756.5.30.1.147.1.1");
        Name name = new Name(elexisPatient.getVorname(), elexisPatient.getName());
        mpiQuery.addPatientName(true, name);
        String birthDate = elexisPatient.getGeburtsdatum();
        if (birthDate != null && !birthDate.isEmpty()) {
            mpiQuery.setPatientDateOfBirth(DateUtil.date((String)birthDate));
        }
        if (!(ret = ConvenienceMasterPatientIndexV3.queryPatientDemographics((MasterPatientIndexQuery)mpiQuery, (AffinityDomain)this.affinityDomain)).getSuccess()) {
            throw new IllegalStateException("Error contacting meineimpfungen Service");
        }
        return ret.getPatients();
    }

    private Identificator getPatientId(Patient elexisPatient) {
        String socialSecurityNumber = elexisPatient.getXid("www.ahv.ch/xid");
        if (socialSecurityNumber != null) {
            socialSecurityNumber = socialSecurityNumber.trim();
            if ((socialSecurityNumber = socialSecurityNumber.replaceAll("\\.", "")).length() == 11) {
                return new Identificator(CodeSystems.SwissSSNDeprecated.getCodeSystemId(), socialSecurityNumber);
            }
            if (socialSecurityNumber.length() == 13) {
                return new Identificator(CodeSystems.SwissSSN.getCodeSystemId(), socialSecurityNumber);
            }
        }
        return null;
    }

    @Override
    public String getBaseUrl() {
        if ("productiv".equals(CoreHub.mandantCfg.get("meineimpfungen.endpoint", "test"))) {
            return "https://meineimpfungen.ch/";
        }
        return "https://test.meineimpfungen.ch/";
    }

    @Override
    public boolean uploadDocument(CdaChVacd document) {
        XDSResponseType response = null;
        try {
            ConvenienceCommunicationCh convComm = new ConvenienceCommunicationCh(this.affinityDomain);
            DocumentMetadataCh metaData = convComm.addChDocument(DocumentDescriptor.CDA_R2, this.getDocumentAsInputStream(document));
            this.setMetadataCdaCh(metaData, document);
            response = convComm.submit();
        }
        catch (Exception e) {
            logger.error("Error uploading document", (Throwable)e);
            return false;
        }
        if (response.getStatus() != null) {
            return response.getStatus().getValue() == 0;
        }
        return false;
    }

    private boolean setMetadataCdaCh(DocumentMetadataCh metaData, CdaChVacd document) {
        metaData.addAuthor(document.getAuthor());
        metaData.setMimeType(MimeType.XML_TEXT);
        Optional<Identificator> patId = this.getMeineImpfungenPatientId(document.getPatient());
        if (!patId.isPresent()) {
            return false;
        }
        metaData.setDestinationPatientId(patId.get());
        metaData.setSourcePatientId(patId.get());
        metaData.setCodedLanguage(LanguageCode.GERMAN);
        metaData.setTypeCode(TypeCode.IMMUNIZATION_RECORD);
        metaData.setFormatCode(FormatCode.IMMUNIZATION_CONTENT);
        metaData.setClassCode(ClassCode.ALERTS);
        metaData.setHealthcareFacilityTypeCode(HealthcareFacilityTypeCode.AMBULATORY_CARE_SITE);
        metaData.addConfidentialityCode(ConfidentialityCode.NORMAL);
        return true;
    }

    private Optional<Identificator> getMeineImpfungenPatientId(org.ehealth_connector.common.Patient patient) {
        List ids = patient.getIds();
        if (ids != null && !ids.isEmpty()) {
            for (Identificator identificator : ids) {
                if (!"2.16.756.5.30.1.147.1.1".equals(identificator.getRoot())) continue;
                return Optional.of(identificator);
            }
        }
        return Optional.empty();
    }

    private InputStream getDocumentAsInputStream(CdaChVacd document) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CDAUtil.save((ClinicalDocument)((ClinicalDocument)document.getMdht()), (OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private class MandantChangedListener
    extends ElexisEventListenerImpl {
        public MandantChangedListener() {
            super(Mandant.class, 128);
        }

        public void run(ElexisEvent ev) {
            MeineImpfungenServiceImpl.this.updateConfiguration();
        }
    }
}

