/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.preference;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static String EHC_OUTPUTDIR = "at.medevit.elexis.ehc.ui.output.dir";
    public static String EHC_INPUTDIR = "at.medevit.elexis.ehc.ui.input.dir";

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.userCfg));
        this.setDescription("e-Health Connector Einstellungen");
        PreferencePage.initDirectories();
    }

    public static void initDirectories() {
        if (CoreHub.userCfg.get(EHC_OUTPUTDIR, "notset").equals("notset")) {
            File outputDir = new File(PreferencePage.getDefaultOutputDir());
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            CoreHub.userCfg.set(EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
        }
        if (CoreHub.userCfg.get(EHC_INPUTDIR, "notset").equals("notset")) {
            File inputDir = new File(PreferencePage.getDefaultInputDir());
            if (!inputDir.exists()) {
                inputDir.mkdirs();
            }
            CoreHub.userCfg.set(EHC_INPUTDIR, PreferencePage.getDefaultInputDir());
        }
    }

    protected void createFieldEditors() {
        DirectoryFieldEditor editor = new DirectoryFieldEditor(EHC_OUTPUTDIR, "Standard Ausgabeverzeichnis", this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        editor = new DirectoryFieldEditor(EHC_INPUTDIR, "Standard Eingangsverzeichnis", this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
    }

    public static String getDefaultOutputDir() {
        return CoreHub.getWritableUserDir() + File.separator + "eHC" + File.separator + "output";
    }

    public static String getDefaultInputDir() {
        return CoreHub.getWritableUserDir() + File.separator + "eHC" + File.separator + "input";
    }
}

