/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.model;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.ui.service.ServiceComponent;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.ehealth_connector.cda.ch.AbstractCdaChV1;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcDocument
extends PersistentObject {
    private static Logger logger = LoggerFactory.getLogger(EhcDocument.class);
    public static final String TABLENAME = "at_medevit_elexis_ehc_document";
    public static final String VERSION = "1.0.0";
    public static final String VERSIONID = "VERSION";
    public static final String FLD_NAME = "name";
    public static final String FLD_TIMESTAMP = "timestamp";
    public static final String FLD_PATIENT = "patient";
    public static final String FLD_LOCATION = "location";
    static final String create = "CREATE TABLE at_medevit_elexis_ehc_document (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',name VARCHAR(255),timestamp VARCHAR(16),patient VARCHAR(128),location VARCHAR(255));CREATE INDEX ehcdoc1 ON at_medevit_elexis_ehc_document (patient);INSERT INTO at_medevit_elexis_ehc_document (ID,patient) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        EhcDocument.addMapping((String)TABLENAME, (String[])new String[]{FLD_NAME, FLD_TIMESTAMP, FLD_PATIENT, FLD_LOCATION});
        if (!EhcDocument.tableExists((String)TABLENAME)) {
            EhcDocument.createOrModifyTable((String)create);
        } else {
            EhcDocument version = EhcDocument.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENT));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_PATIENT, VERSION);
            }
        }
    }

    public EhcDocument() {
    }

    public EhcDocument(String id) {
        super(id);
    }

    public static EhcDocument load(String id) {
        return new EhcDocument(id);
    }

    public EhcDocument(String name, URL location, TimeTool creation) {
        this.create(null);
        String[] fields = new String[]{FLD_NAME, FLD_TIMESTAMP, FLD_LOCATION};
        String[] vals = new String[]{name, creation.toString(13), location.toString()};
        this.set(fields, vals);
        Patient patient = null;
        if (this.isEhcType(EhcDocType.CLINICALDOCUMENT)) {
            patient = this.getPatientFromDocument(location);
        }
        if (patient != null) {
            this.setPatient(patient);
        }
    }

    public boolean isEhcType(EhcDocType type) {
        return this.getName().contains("[" + (Object)((Object)type) + "]");
    }

    private Patient getPatientFromDocument(URL location) {
        Patient ret = null;
        try {
            if (EhcDocument.isEhcXml(location)) {
                org.ehealth_connector.common.Patient patient;
                ClinicalDocument clinicalDocument = ServiceComponent.getEhcService().loadDocument(location.openStream());
                AbstractCdaChV1 cdaCh = ServiceComponent.getEhcService().getAsCdaChDocument(clinicalDocument);
                if (cdaCh != null && (patient = cdaCh.getPatient()) != null) {
                    ret = EhcCoreMapper.getElexisPatient((org.ehealth_connector.common.Patient)patient);
                }
            }
        }
        catch (IOException e) {
            logger.error("Could not open location.", (Throwable)e);
        }
        return ret;
    }

    public String getName() {
        return this.get(FLD_NAME);
    }

    public void setName(String name) {
        this.set(FLD_NAME, name);
    }

    public URL getLocation() {
        try {
            return new URL(this.get(FLD_LOCATION));
        }
        catch (MalformedURLException e) {
            logger.error("Could create URL for location.", (Throwable)e);
            return null;
        }
    }

    public void setLocation(URL location) {
        this.set(FLD_LOCATION, location.toString());
    }

    public Patient getPatient() {
        Patient patient;
        String id = this.get(FLD_PATIENT);
        if (id != null && !id.isEmpty() && (patient = Patient.load((String)id)).exists()) {
            return patient;
        }
        return null;
    }

    public void setPatient(Patient patient) {
        this.set(FLD_PATIENT, patient.getId());
    }

    public static boolean documentExists(URL url) {
        Query qd = new Query(EhcDocument.class);
        qd.add(FLD_LOCATION, "=", url.toString());
        List existing = qd.execute();
        return !existing.isEmpty();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEhcXml(URL url) {
        if (url.getPath().endsWith(".xml") == false) return false;
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                stream = url.openStream();
                try {
                    br = new BufferedReader(new InputStreamReader(stream));
                    try {
                        line = null;
                        i = 0;
                        while (true) {
                            line = br.readLine();
                            if (line == null) break;
                            if (!line.contains("<ClinicalDocument")) ** GOTO lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                ++i;
                                return (boolean)i;
                            }
                            break;
                        }
                    }
                    finally {
                        if (i < 100) ** continue;
                    }
                    if (stream == null) return false;
                }
                catch (Throwable var2_5) {
                    if (var1_1 == null) {
                        var1_1 = var2_5;
                    } else if (var1_1 != var2_5) {
                        var1_1.addSuppressed(var2_5);
                    }
                    if (stream == null) throw var1_1;
                    stream.close();
                    throw var1_1;
                }
                stream.close();
                return false;
            }
            catch (Throwable var2_6) {
                if (var1_1 == null) {
                    var1_1 = var2_6;
                    throw var1_1;
                }
                if (var1_1 == var2_6) throw var1_1;
                var1_1.addSuppressed(var2_6);
                throw var1_1;
            }
        }
        catch (IOException var1_3) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEhcXdm(URL url) {
        File file;
        String fileName;
        if ((url.getPath().endsWith(".zip") || url.getPath().endsWith(".xdm")) && (fileName = url.getFile()) != null && !fileName.isEmpty() && (file = new File(fileName)).exists()) {
            List patients = ServiceComponent.getEhcService().getXdmPatients(file);
            return patients != null;
        }
        return false;
    }

    public static EhcDocument createFromXml(URL fileUrl) {
        File file = new File(fileUrl.getFile());
        return new EhcDocument(String.valueOf(file.getName()) + " [" + (Object)((Object)EhcDocType.CLINICALDOCUMENT) + "]", fileUrl, new TimeTool());
    }

    public static EhcDocument createFromXdm(URL fileUrl) {
        File xdmFile = new File(fileUrl.getPath());
        EhcDocument ret = new EhcDocument(String.valueOf(xdmFile.getName()) + " [" + (Object)((Object)EhcDocType.XDM) + "]", fileUrl, new TimeTool());
        List documents = ServiceComponent.getEhcService().getXdmDocuments(xdmFile);
        for (ClinicalDocument clinicalDocument : documents) {
            File documentFile = EhcDocument.getXdmDocumentFile(clinicalDocument, xdmFile);
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (FileOutputStream outputStream = new FileOutputStream(documentFile);){
                    CDAUtil.save((ClinicalDocument)clinicalDocument, (OutputStream)outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.error("Could not create EhcDocument from xdm.", (Throwable)e);
            }
        }
        return ret;
    }

    private static File getXdmDocumentFile(ClinicalDocument clinicalDocument, File xdmFile) {
        String rootPath = xdmFile.getParent();
        String rootName = xdmFile.getName();
        rootName = rootName.replaceAll("\\.", "");
        File file = null;
        int i = 0;
        while (i < 100) {
            file = new File(String.valueOf(rootPath) + File.separator + rootName + "_" + i + ".xml");
            if (!file.exists()) break;
            ++i;
        }
        return file;
    }

    public String getLabel() {
        return this.getName().replaceAll("\\[[A-Z]+\\]", "");
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static enum EhcDocType {
        CLINICALDOCUMENT,
        XDM;

    }
}

