/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.inbox;

import at.medevit.elexis.ehc.ui.inbox.InboxListener;
import at.medevit.elexis.ehc.ui.model.EhcDocument;
import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Mandant;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxWatcher {
    private static Logger logger = LoggerFactory.getLogger(InboxWatcher.class);
    private MandantChangedListener mandantListener;
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private WatchService watcher;
    private HashMap<String, WatchKey> watchKeys;
    private String activeInboxString;
    private static String LinuxIoNtifyHint = "The inbox will not work correctly.\n\nHINT: Under linux calling 'echo 256 > /proc/sys/fs/inotify/max_user_instances' might fix the problem";
    private List<InboxListener> listeners;

    public InboxWatcher() {
        this.mandantListener = new MandantChangedListener();
        this.watchKeys = new HashMap();
        this.listeners = new ArrayList<InboxListener>();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.mandantListener});
    }

    public void start() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.executor.execute(new DirectoryWatcher());
        }
        catch (IOException e) {
            logger.error(LinuxIoNtifyHint);
            logger.error("Error creating filesystem watcher", (Throwable)e);
        }
    }

    public void stop() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.mandantListener});
        try {
            this.executor.shutdown();
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
        catch (IOException e) {
            logger.error("Error closing filesystem watcher", (Throwable)e);
        }
    }

    public synchronized void addInboxListener(InboxListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeInboxListener(InboxListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInboxCreated(EhcDocument newDocument) {
        for (InboxListener inboxListener : this.listeners) {
            inboxListener.documentCreated(newDocument);
        }
    }

    private class DirectoryDocumentStrategy {
        private DirectoryDocumentStrategy() {
        }

        public void execute(URL fileUrl) {
            if (!EhcDocument.documentExists(fileUrl)) {
                if (EhcDocument.isEhcXml(fileUrl)) {
                    InboxWatcher.this.fireInboxCreated(EhcDocument.createFromXml(fileUrl));
                } else if (EhcDocument.isEhcXdm(fileUrl)) {
                    EhcDocument.createFromXdm(fileUrl);
                }
            }
        }
    }

    private class DirectoryInitializer
    implements Runnable {
        private DirectoryDocumentStrategy documentStrategy;

        public DirectoryInitializer() {
            this.documentStrategy = new DirectoryDocumentStrategy();
        }

        @Override
        public void run() {
            File[] files;
            File inboxFolder = new File(InboxWatcher.this.activeInboxString);
            if (!inboxFolder.exists()) {
                PreferencePage.initDirectories();
            }
            if ((files = inboxFolder.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isDirectory()) {
                        try {
                            URL fileUrl = new URL("file:///" + file.getAbsolutePath());
                            this.documentStrategy.execute(fileUrl);
                        }
                        catch (MalformedURLException e) {
                            logger.error("Error initializing inbox.", (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private class DirectoryWatcher
    implements Runnable {
        private DirectoryDocumentStrategy documentStrategy;

        public DirectoryWatcher() {
            this.documentStrategy = new DirectoryDocumentStrategy();
        }

        @Override
        public void run() {
            WatchKey key = null;
            try {
                do {
                    key = InboxWatcher.this.watcher.take();
                    WatchEvent.Kind<?> kind = null;
                    for (WatchEvent<?> watchEvent : key.pollEvents()) {
                        kind = watchEvent.kind();
                        if (StandardWatchEventKinds.OVERFLOW == kind || StandardWatchEventKinds.ENTRY_CREATE != kind) continue;
                        Path newPath = (Path)watchEvent.context();
                        String newInboxPath = String.valueOf(InboxWatcher.this.activeInboxString) + File.separator + newPath.getFileName().toString();
                        URL fileUrl = new URL("file:///" + newInboxPath);
                        this.documentStrategy.execute(fileUrl);
                    }
                } while (key.reset());
            }
            catch (InterruptedException | MalformedURLException e) {
                logger.error("Filesystem watching interrupted stopping", (Throwable)e);
            }
        }
    }

    private class MandantChangedListener
    extends ElexisUiEventListenerImpl {
        public MandantChangedListener() {
            super(Mandant.class, 128);
        }

        public void runInUi(ElexisEvent ev) {
            InboxWatcher.this.activeInboxString = CoreHub.userCfg.get(PreferencePage.EHC_INPUTDIR, PreferencePage.getDefaultInputDir());
            InboxWatcher.this.executor.execute(new DirectoryInitializer());
            if (InboxWatcher.this.watchKeys.get(InboxWatcher.this.activeInboxString) == null) {
                try {
                    Path inboxPath = Paths.get(InboxWatcher.this.activeInboxString, new String[0]);
                    if (!inboxPath.toFile().exists()) {
                        inboxPath.toFile().mkdirs();
                    }
                    if (InboxWatcher.this.watcher == null) {
                        String errorTitle = "Unable to create file watcher";
                        Status status = new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), 4, errorTitle, null);
                        ErrorDialog.openError(null, (String)"Unable to create file watcher", (String)LinuxIoNtifyHint, (IStatus)status);
                    } else {
                        WatchKey key = inboxPath.register(InboxWatcher.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                        InboxWatcher.this.watchKeys.put(InboxWatcher.this.activeInboxString, key);
                    }
                }
                catch (IOException e) {
                    logger.error("Error creating filesystem key", (Throwable)e);
                }
            }
        }
    }
}

