/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.inbox;

import at.medevit.elexis.ehc.ui.inbox.EhcDocumentLabelProvider;
import at.medevit.elexis.ehc.ui.inbox.filter.EhcDocumentViewerFilter;
import at.medevit.elexis.ehc.ui.model.EhcDocument;
import at.medevit.elexis.ehc.ui.views.EHealthConnectorView;
import at.medevit.elexis.inbox.model.InboxElement;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxElementUiProvider
implements IInboxElementUiProvider {
    private static Logger logger = LoggerFactory.getLogger(InboxElementUiProvider.class);
    private EhcDocumentLabelProvider labelProvider = new EhcDocumentLabelProvider();
    private EhcDocumentViewerFilter filter = new EhcDocumentViewerFilter();

    public ImageDescriptor getFilterImage() {
        return ResourceManager.getPluginImageDescriptor("at.medevit.elexis.ehc.ui", "icons/ehc.jpg");
    }

    public ViewerFilter getFilter() {
        return this.filter;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IColorProvider getColorProvider() {
        return null;
    }

    public boolean isProviderFor(InboxElement element) {
        Object obj = element.getObject();
        return obj instanceof EhcDocument;
    }

    public void doubleClicked(InboxElement element) {
        Object obj = element.getObject();
        if (obj instanceof EhcDocument) {
            EhcDocument document = (EhcDocument)((Object)obj);
            try {
                EHealthConnectorView view = (EHealthConnectorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("at.medevit.elexis.eHealthConnectorView");
                view.displayReport(document.getLocation().openStream(), null);
            }
            catch (IOException | PartInitException e) {
                logger.error("Could not open ehc document", e);
            }
        }
    }
}

