/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.wizard;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.ehc.ui.vacdoc.wizard.ImportVaccinationsWizard;
import ch.elexis.data.Patient;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.ehealth_connector.cda.ch.vacd.CdaChVacd;
import org.ehealth_connector.cda.ch.vacd.Immunization;

public class ImportVaccinationsWizardPage1
extends WizardPage {
    private TableViewer contentViewer;
    private CdaChVacd ehcDocument;

    protected ImportVaccinationsWizardPage1(String pageName, CdaChVacd ehcDocument) {
        super(pageName);
        this.setTitle(pageName);
        this.ehcDocument = ehcDocument;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.contentViewer = new TableViewer(composite, 2818);
        Control control = this.contentViewer.getControl();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        control.setLayoutData((Object)gd);
        this.contentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Immunization) {
                    Immunization immunization = (Immunization)element;
                    return "(" + immunization.getApplyDate() + ") " + immunization.getConsumable().getTradeName() + " - " + immunization.getAuthor().getCompleteName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }
        });
        this.contentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportVaccinationsWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.ehcDocument != null) {
            List immunizations = this.ehcDocument.getImmunizations();
            this.contentViewer.setInput((Object)immunizations);
            this.contentViewer.setSelection((ISelection)new StructuredSelection(immunizations), true);
        }
    }

    public boolean isPageComplete() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        return !contentSelection.isEmpty();
    }

    private List<Immunization> getSelectedImmunizations() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        if (!contentSelection.isEmpty()) {
            return contentSelection.toList();
        }
        return Collections.emptyList();
    }

    public boolean finish() {
        try {
            Patient elexisPatient = EhcCoreMapper.getElexisPatient((org.ehealth_connector.common.Patient)this.ehcDocument.getPatient());
            VacdocServiceComponent.getService().importImmunizations(elexisPatient, this.getSelectedImmunizations());
        }
        catch (Exception e) {
            ImportVaccinationsWizard.logger.error("Import failed.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Es ist ein Fehler beim Impfungen importieren aufgetreten.");
            return false;
        }
        return true;
    }
}

