/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.wizard;

import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import at.medevit.elexis.ehc.ui.vacdoc.service.OutboxElementServiceHolder;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.ehc.ui.vacdoc.wizard.ExportVaccinationsWizard;
import at.medevit.elexis.ehc.vacdoc.service.VacdocService;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.outbox.model.OutboxElementType;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.ehealth_connector.cda.ch.vacd.CdaChVacd;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;

public class ExportVaccinationsWizardPage1
extends WizardPage {
    private TableViewer contentViewer;
    private Patient selectedPatient;
    private final ExportVaccinationsWizard.ExportType exportType;

    protected ExportVaccinationsWizardPage1(String pageName, ExportVaccinationsWizard.ExportType exportType) {
        super(pageName);
        this.setTitle(pageName);
        this.exportType = exportType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.contentViewer = new TableViewer(composite, 2818);
        Control control = this.contentViewer.getControl();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        control.setLayoutData((Object)gd);
        this.contentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Vaccination) {
                    return ((Vaccination)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }
        });
        this.contentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportVaccinationsWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite c = new Composite(composite, 0x4000000);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage(null);
            Query qbe = new Query(Vaccination.class);
            this.selectedPatient = ElexisEventDispatcher.getSelectedPatient();
            if (this.selectedPatient != null) {
                qbe.add("Patient_ID", "=", this.selectedPatient.getId());
                qbe.orderBy(true, new String[]{"dateOfAdministration", "lastupdate"});
                List vaccinations = qbe.execute();
                this.contentViewer.setInput((Object)vaccinations);
                this.contentViewer.setSelection((ISelection)new StructuredSelection(vaccinations), true);
                String ahvNr = this.selectedPatient.getXid("www.ahv.ch/xid");
                if (ahvNr == null || ahvNr.isEmpty()) {
                    this.setErrorMessage("Patient hat keine AHV Nummer.");
                }
            } else {
                this.setErrorMessage("Es ist kein Patient ausgew\u00e4hlt.");
            }
        }
    }

    public boolean isPageComplete() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        String ahvNr = this.selectedPatient.getXid("www.ahv.ch/xid");
        return !contentSelection.isEmpty() && ahvNr != null && !ahvNr.isEmpty();
    }

    private List<Vaccination> getSelectedVaccinations() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        if (!contentSelection.isEmpty()) {
            return contentSelection.toList();
        }
        return Collections.emptyList();
    }

    public boolean finish() {
        String outputFile = "";
        try {
            Patient elexisPatient = ElexisEventDispatcher.getSelectedPatient();
            Mandant elexisMandant = ElexisEventDispatcher.getSelectedMandator();
            String outputDir = CoreHub.userCfg.get(PreferencePage.EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
            VacdocService service = VacdocServiceComponent.getService();
            CdaChVacd document = service.getVacdocDocument(elexisPatient, elexisMandant);
            service.addVaccinations(document, this.getSelectedVaccinations());
            switch (this.exportType) {
                case CDA: {
                    outputFile = this.writeAsCDA(elexisPatient, outputDir, service, document);
                    this.createOutboxElement(elexisPatient, elexisMandant, outputFile);
                    break;
                }
                case XDM: {
                    outputFile = this.writeAsXDM(elexisPatient, outputDir, service, document);
                    break;
                }
            }
        }
        catch (Exception e) {
            ExportVaccinationsWizard.logger.error("Export failed.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Es ist ein Fehler beim Impfungen exportiern nach [" + outputFile + "] aufgetreten."));
            return false;
        }
        return true;
    }

    private void createOutboxElement(Patient patient, Mandant mandant, String outputFile) {
        OutboxElementServiceHolder.getService().createOutboxElement(patient, (Kontakt)mandant, String.valueOf(OutboxElementType.FILE.getPrefix()) + outputFile);
    }

    private String writeAsXDM(Patient elexisPatient, String outputDir, VacdocService service, CdaChVacd document) throws Exception, FileNotFoundException, IOException {
        InputStream xdmDocumentStream = service.getXdmAsStream(document);
        String outputFile = String.valueOf(outputDir) + File.separator + this.getVaccinationsFileName(elexisPatient) + ".xdm";
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)xdmDocumentStream, (OutputStream)outputStream);
        xdmDocumentStream.close();
        outputStream.close();
        return outputFile;
    }

    private String writeAsCDA(Patient elexisPatient, String outputDir, VacdocService service, CdaChVacd document) throws Exception, FileNotFoundException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CDAUtil.save((ClinicalDocument)((ClinicalDocument)document.getMdht()), (OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String outputFile = String.valueOf(outputDir) + File.separator + this.getVaccinationsFileName(elexisPatient) + "_" + System.currentTimeMillis() + ".xml";
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)in, (OutputStream)outputStream);
        ((InputStream)in).close();
        outputStream.close();
        return outputFile;
    }

    private String getVaccinationsFileName(Patient patient) {
        return "vacc_" + patient.getPatCode();
    }
}

