/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.handler;

import at.medevit.elexis.ehc.ui.vacdoc.handler.OpenMeineImpfungenHandler;
import at.medevit.elexis.ehc.ui.vacdoc.service.MeineImpfungenServiceHolder;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Patient;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.ehealth_connector.cda.ch.vacd.CdaChVacd;
import org.ehealth_connector.common.Identificator;
import org.slf4j.LoggerFactory;

public class UploadMeineImpfungenHandler
extends AbstractHandler
implements IHandler {
    private Vaccination selectedVacination;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        try {
            final Patient patient = ElexisEventDispatcher.getSelectedPatient();
            ISelection selection = HandlerUtil.getActiveSite((ExecutionEvent)event).getSelectionProvider().getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                this.selectedVacination = (Vaccination)((StructuredSelection)selection).getFirstElement();
            }
            if (patient != null && this.selectedVacination != null) {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                try {
                    progress.run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Impfung export nach meineimpfungen ...", -1);
                            List patients = MeineImpfungenServiceHolder.getService().getPatients(patient);
                            if (patients != null && !patients.isEmpty()) {
                                if (patients.size() == 1) {
                                    CdaChVacd document = VacdocServiceComponent.getService().getVacdocDocument(patient, ElexisEventDispatcher.getSelectedMandator());
                                    this.setMeineImpfungenPatientId(document.getPatient(), (org.ehealth_connector.common.Patient)patients.get(0));
                                    VacdocServiceComponent.getService().addVaccinations(document, Collections.singletonList(UploadMeineImpfungenHandler.this.selectedVacination));
                                    boolean success = MeineImpfungenServiceHolder.getService().uploadDocument(document);
                                    if (!success) {
                                        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"Beim upload ist ein Fehler aufgetreten.");
                                    }
                                } else {
                                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)("Mehrere Patienten f\u00fcr [" + patient.getLabel(false) + "] auf meineimpfungen gefunden."));
                                }
                            } else {
                                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)("Kein Patient [" + patient.getLabel(false) + "] auf meineimpfungen gefunden."));
                            }
                            monitor.done();
                        }

                        private void setMeineImpfungenPatientId(org.ehealth_connector.common.Patient docPatient, org.ehealth_connector.common.Patient miPatient) {
                            List ids = miPatient.getIds();
                            if (ids != null && !ids.isEmpty()) {
                                for (Identificator identificator : ids) {
                                    if (!"2.16.756.5.30.1.147.1.1".equals(identificator.getRoot())) continue;
                                    docPatient.addId(identificator);
                                    return;
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LoggerFactory.getLogger(OpenMeineImpfungenHandler.class).warn("Exception on patient lookup", (Throwable)e);
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"Es ist ein Fehler aufgetreten.");
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"Kein Patient, oder keine Impfung ausgew\u00e4hlt");
            }
        }
        catch (IllegalStateException ise) {
            LoggerFactory.getLogger(OpenMeineImpfungenHandler.class).error("Service not available", (Throwable)ise);
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"meineimpfungen nicht verf\u00fcgbar");
        }
        return null;
    }
}

