/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.handler;

import at.medevit.elexis.ehc.ui.vacdoc.service.MeineImpfungenServiceHolder;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Patient;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.ehealth_connector.common.Identificator;
import org.slf4j.LoggerFactory;

public class OpenMeineImpfungenHandler
extends AbstractHandler
implements IHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        try {
            final Patient patient = ElexisEventDispatcher.getSelectedPatient();
            if (patient != null) {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                try {
                    progress.run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Patient auf meineimpfungen suchen ...", -1);
                            List patients = MeineImpfungenServiceHolder.getService().getPatients(patient);
                            if (patients != null && !patients.isEmpty()) {
                                if (patients.size() == 1) {
                                    StringBuilder link = new StringBuilder();
                                    link.append(MeineImpfungenServiceHolder.getService().getBaseUrl());
                                    if (link.lastIndexOf("/") != link.length() - 1) {
                                        link.append("/");
                                    }
                                    OpenMeineImpfungenHandler.this.getPatientId((org.ehealth_connector.common.Patient)patients.get(0)).ifPresent(pid -> {
                                        link.append("specialist-person-home.html?personId=").append((String)pid);
                                        Program.launch((String)link.toString());
                                    });
                                } else {
                                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)("Mehrere Patienten f\u00fcr [" + patient.getLabel(false) + "] auf meineimpfungen gefunden."));
                                }
                            } else {
                                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)("Kein Patient [" + patient.getLabel(false) + "] auf meineimpfungen gefunden."));
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LoggerFactory.getLogger(OpenMeineImpfungenHandler.class).warn("Exception on patient lookup", (Throwable)e);
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"Es ist ein Fehler aufgetreten.");
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"Kein Patient ausgew\u00e4hlt");
            }
        }
        catch (IllegalStateException ise) {
            LoggerFactory.getLogger(OpenMeineImpfungenHandler.class).error("Service not available", (Throwable)ise);
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"meineimpfungen", (String)"meineimpfungen nicht verf\u00fcgbar");
        }
        return null;
    }

    private Optional<String> getPatientId(org.ehealth_connector.common.Patient ehcPatient) {
        List ids = ehcPatient.getIds();
        if (ids != null && !ids.isEmpty()) {
            for (Identificator identificator : ids) {
                if (!"2.16.756.5.30.1.147.1.1".equals(identificator.getRoot())) continue;
                return Optional.of(identificator.getExtension());
            }
        }
        return Optional.empty();
    }
}

