/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.docbox.wizard;

import at.medevit.elexis.ehc.docbox.service.DocboxService;
import at.medevit.elexis.ehc.ui.docbox.wizard.ExportPrescriptionWizard;
import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import ch.elexis.core.data.activator.CoreHub;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;

public class ExportPrescriptionWizardPage2
extends WizardPage {
    private Text xmlText;

    protected ExportPrescriptionWizardPage2(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.xmlText = new Text(composite, 770);
        this.xmlText.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                CDAUtil.save((ClinicalDocument)ExportPrescriptionWizard.getDocument().getDocRoot().getClinicalDocument(), (OutputStream)output);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Rezept konnte nicht erstellt werden. " + e.getMessage()));
                return;
            }
            this.xmlText.setText(output.toString());
        }
    }

    public boolean isPageComplete() {
        return !this.xmlText.getText().isEmpty();
    }

    private void writePdf(ByteArrayOutputStream pdf) throws FileNotFoundException, IOException {
        String outputDir = CoreHub.userCfg.get(PreferencePage.EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
        File pdfFile = new File(String.valueOf(outputDir) + File.separator + this.getRezeptFileName() + ".pdf");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fos = new FileOutputStream(pdfFile);){
            fos.write(pdf.toByteArray());
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean finish() {
        try {
            String outputDir = CoreHub.userCfg.get(PreferencePage.EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
            ExportPrescriptionWizard.getDocument().saveToFile(String.valueOf(outputDir) + File.separator + this.getRezeptFileName() + ".xml");
            ByteArrayOutputStream pdf = DocboxService.getPrescriptionPdf(ExportPrescriptionWizard.getDocument());
            this.writePdf(pdf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getRezeptFileName() {
        String ret = ExportPrescriptionWizard.getRezept().getLabel();
        return ret.replaceAll(" ", "_");
    }
}

