/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.docbox.wizard;

import at.medevit.elexis.ehc.docbox.service.DocboxService;
import at.medevit.elexis.ehc.ui.docbox.wizard.ExportPrescriptionWizard;
import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rezept;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.ehealth_connector.cda.ch.AbstractCdaChV1;

public class ExportPrescriptionWizardPage1
extends WizardPage {
    private TableViewer contentViewer;

    protected ExportPrescriptionWizardPage1(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.contentViewer = new TableViewer(composite, 2816);
        Control control = this.contentViewer.getControl();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        control.setLayoutData((Object)gd);
        this.contentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Rezept) {
                    return ((Rezept)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }
        });
        this.contentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportPrescriptionWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Query qbe = new Query(Rezept.class);
            Patient selectedPatient = ElexisEventDispatcher.getSelectedPatient();
            if (selectedPatient != null) {
                qbe.add("PatientID", "=", selectedPatient.getId());
                qbe.orderBy(true, new String[]{"Datum", "lastupdate"});
            }
            this.contentViewer.setInput((Object)qbe.execute());
        }
    }

    public boolean isPageComplete() {
        Rezept selectedRezept;
        AbstractCdaChV1 document;
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        if (!contentSelection.isEmpty() && (document = DocboxService.getPrescriptionDocument((Rezept)(selectedRezept = (Rezept)contentSelection.getFirstElement()))) != null) {
            ExportPrescriptionWizard.setRezept(selectedRezept);
            ExportPrescriptionWizard.setDocument(document);
            return true;
        }
        return false;
    }

    private void writePdf(ByteArrayOutputStream pdf) throws FileNotFoundException, IOException {
        String outputDir = CoreHub.userCfg.get(PreferencePage.EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
        File pdfFile = new File(String.valueOf(outputDir) + File.separator + this.getRezeptFileName() + ".pdf");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fos = new FileOutputStream(pdfFile);){
            fos.write(pdf.toByteArray());
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean finish() {
        try {
            String outputDir = CoreHub.userCfg.get(PreferencePage.EHC_OUTPUTDIR, PreferencePage.getDefaultOutputDir());
            ExportPrescriptionWizard.getDocument().saveToFile(String.valueOf(outputDir) + File.separator + this.getRezeptFileName() + ".xml");
            ByteArrayOutputStream pdf = DocboxService.getPrescriptionPdf(ExportPrescriptionWizard.getDocument());
            this.writePdf(pdf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getRezeptFileName() {
        String ret = ExportPrescriptionWizard.getRezept().getLabel();
        return ret.replaceAll(" ", "_");
    }
}

